<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTelemetricDataItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfTelemetricDataItem extends AbstractStructArrayBase
{
    /**
     * The TelemetricDataItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TelemetricDataItem[]
     */
    public $TelemetricDataItem;
    /**
     * Constructor method for ArrayOfTelemetricDataItem
     * @uses ArrayOfTelemetricDataItem::setTelemetricDataItem()
     * @param \StructType\TelemetricDataItem[] $telemetricDataItem
     */
    public function __construct(array $telemetricDataItem = array())
    {
        $this
            ->setTelemetricDataItem($telemetricDataItem);
    }
    /**
     * Get TelemetricDataItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TelemetricDataItem[]|null
     */
    public function getTelemetricDataItem()
    {
        return isset($this->TelemetricDataItem) ? $this->TelemetricDataItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTelemetricDataItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTelemetricDataItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTelemetricDataItemForArrayConstraintsFromSetTelemetricDataItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTelemetricDataItemTelemetricDataItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfTelemetricDataItemTelemetricDataItemItem instanceof \StructType\TelemetricDataItem) {
                $invalidValues[] = is_object($arrayOfTelemetricDataItemTelemetricDataItemItem) ? get_class($arrayOfTelemetricDataItemTelemetricDataItemItem) : sprintf('%s(%s)', gettype($arrayOfTelemetricDataItemTelemetricDataItemItem), var_export($arrayOfTelemetricDataItemTelemetricDataItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TelemetricDataItem property can only contain items of type \StructType\TelemetricDataItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TelemetricDataItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TelemetricDataItem[] $telemetricDataItem
     * @return \ArrayType\ArrayOfTelemetricDataItem
     */
    public function setTelemetricDataItem(array $telemetricDataItem = array())
    {
        // validation for constraint: array
        if ('' !== ($telemetricDataItemArrayErrorMessage = self::validateTelemetricDataItemForArrayConstraintsFromSetTelemetricDataItem($telemetricDataItem))) {
            throw new \InvalidArgumentException($telemetricDataItemArrayErrorMessage, __LINE__);
        }
        if (is_null($telemetricDataItem) || (is_array($telemetricDataItem) && empty($telemetricDataItem))) {
            unset($this->TelemetricDataItem);
        } else {
            $this->TelemetricDataItem = $telemetricDataItem;
        }
        return $this;
    }
    /**
     * Add item to TelemetricDataItem value
     * @throws \InvalidArgumentException
     * @param \StructType\TelemetricDataItem $item
     * @return \ArrayType\ArrayOfTelemetricDataItem
     */
    public function addToTelemetricDataItem(\StructType\TelemetricDataItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TelemetricDataItem) {
            throw new \InvalidArgumentException(sprintf('The TelemetricDataItem property can only contain items of type \StructType\TelemetricDataItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TelemetricDataItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TelemetricDataItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TelemetricDataItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TelemetricDataItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TelemetricDataItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TelemetricDataItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TelemetricDataItem
     */
    public function getAttributeName()
    {
        return 'TelemetricDataItem';
    }
}
