<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfStreetInfoResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfStreetInfoResult extends AbstractStructArrayBase
{
    /**
     * The StreetInfoResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StreetInfoResult[]
     */
    public $StreetInfoResult;
    /**
     * Constructor method for ArrayOfStreetInfoResult
     * @uses ArrayOfStreetInfoResult::setStreetInfoResult()
     * @param \StructType\StreetInfoResult[] $streetInfoResult
     */
    public function __construct(array $streetInfoResult = array())
    {
        $this
            ->setStreetInfoResult($streetInfoResult);
    }
    /**
     * Get StreetInfoResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StreetInfoResult[]|null
     */
    public function getStreetInfoResult()
    {
        return isset($this->StreetInfoResult) ? $this->StreetInfoResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setStreetInfoResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStreetInfoResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStreetInfoResultForArrayConstraintsFromSetStreetInfoResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfStreetInfoResultStreetInfoResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfStreetInfoResultStreetInfoResultItem instanceof \StructType\StreetInfoResult) {
                $invalidValues[] = is_object($arrayOfStreetInfoResultStreetInfoResultItem) ? get_class($arrayOfStreetInfoResultStreetInfoResultItem) : sprintf('%s(%s)', gettype($arrayOfStreetInfoResultStreetInfoResultItem), var_export($arrayOfStreetInfoResultStreetInfoResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StreetInfoResult property can only contain items of type \StructType\StreetInfoResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StreetInfoResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\StreetInfoResult[] $streetInfoResult
     * @return \ArrayType\ArrayOfStreetInfoResult
     */
    public function setStreetInfoResult(array $streetInfoResult = array())
    {
        // validation for constraint: array
        if ('' !== ($streetInfoResultArrayErrorMessage = self::validateStreetInfoResultForArrayConstraintsFromSetStreetInfoResult($streetInfoResult))) {
            throw new \InvalidArgumentException($streetInfoResultArrayErrorMessage, __LINE__);
        }
        if (is_null($streetInfoResult) || (is_array($streetInfoResult) && empty($streetInfoResult))) {
            unset($this->StreetInfoResult);
        } else {
            $this->StreetInfoResult = $streetInfoResult;
        }
        return $this;
    }
    /**
     * Add item to StreetInfoResult value
     * @throws \InvalidArgumentException
     * @param \StructType\StreetInfoResult $item
     * @return \ArrayType\ArrayOfStreetInfoResult
     */
    public function addToStreetInfoResult(\StructType\StreetInfoResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StreetInfoResult) {
            throw new \InvalidArgumentException(sprintf('The StreetInfoResult property can only contain items of type \StructType\StreetInfoResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->StreetInfoResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\StreetInfoResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\StreetInfoResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\StreetInfoResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\StreetInfoResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\StreetInfoResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string StreetInfoResult
     */
    public function getAttributeName()
    {
        return 'StreetInfoResult';
    }
}
