<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSocialSubGroupItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfSocialSubGroupItem extends AbstractStructArrayBase
{
    /**
     * The SocialSubGroupItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SocialSubGroupItem[]
     */
    public $SocialSubGroupItem;
    /**
     * Constructor method for ArrayOfSocialSubGroupItem
     * @uses ArrayOfSocialSubGroupItem::setSocialSubGroupItem()
     * @param \StructType\SocialSubGroupItem[] $socialSubGroupItem
     */
    public function __construct(array $socialSubGroupItem = array())
    {
        $this
            ->setSocialSubGroupItem($socialSubGroupItem);
    }
    /**
     * Get SocialSubGroupItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SocialSubGroupItem[]|null
     */
    public function getSocialSubGroupItem()
    {
        return isset($this->SocialSubGroupItem) ? $this->SocialSubGroupItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSocialSubGroupItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSocialSubGroupItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSocialSubGroupItemForArrayConstraintsFromSetSocialSubGroupItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSocialSubGroupItemSocialSubGroupItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfSocialSubGroupItemSocialSubGroupItemItem instanceof \StructType\SocialSubGroupItem) {
                $invalidValues[] = is_object($arrayOfSocialSubGroupItemSocialSubGroupItemItem) ? get_class($arrayOfSocialSubGroupItemSocialSubGroupItemItem) : sprintf('%s(%s)', gettype($arrayOfSocialSubGroupItemSocialSubGroupItemItem), var_export($arrayOfSocialSubGroupItemSocialSubGroupItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SocialSubGroupItem property can only contain items of type \StructType\SocialSubGroupItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SocialSubGroupItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SocialSubGroupItem[] $socialSubGroupItem
     * @return \ArrayType\ArrayOfSocialSubGroupItem
     */
    public function setSocialSubGroupItem(array $socialSubGroupItem = array())
    {
        // validation for constraint: array
        if ('' !== ($socialSubGroupItemArrayErrorMessage = self::validateSocialSubGroupItemForArrayConstraintsFromSetSocialSubGroupItem($socialSubGroupItem))) {
            throw new \InvalidArgumentException($socialSubGroupItemArrayErrorMessage, __LINE__);
        }
        if (is_null($socialSubGroupItem) || (is_array($socialSubGroupItem) && empty($socialSubGroupItem))) {
            unset($this->SocialSubGroupItem);
        } else {
            $this->SocialSubGroupItem = $socialSubGroupItem;
        }
        return $this;
    }
    /**
     * Add item to SocialSubGroupItem value
     * @throws \InvalidArgumentException
     * @param \StructType\SocialSubGroupItem $item
     * @return \ArrayType\ArrayOfSocialSubGroupItem
     */
    public function addToSocialSubGroupItem(\StructType\SocialSubGroupItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SocialSubGroupItem) {
            throw new \InvalidArgumentException(sprintf('The SocialSubGroupItem property can only contain items of type \StructType\SocialSubGroupItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SocialSubGroupItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SocialSubGroupItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SocialSubGroupItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SocialSubGroupItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SocialSubGroupItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SocialSubGroupItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SocialSubGroupItem
     */
    public function getAttributeName()
    {
        return 'SocialSubGroupItem';
    }
}
