<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSocialSubChildItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfSocialSubChildItem extends AbstractStructArrayBase
{
    /**
     * The SocialSubChildItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SocialSubChildItem[]
     */
    public $SocialSubChildItem;
    /**
     * Constructor method for ArrayOfSocialSubChildItem
     * @uses ArrayOfSocialSubChildItem::setSocialSubChildItem()
     * @param \StructType\SocialSubChildItem[] $socialSubChildItem
     */
    public function __construct(array $socialSubChildItem = array())
    {
        $this
            ->setSocialSubChildItem($socialSubChildItem);
    }
    /**
     * Get SocialSubChildItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SocialSubChildItem[]|null
     */
    public function getSocialSubChildItem()
    {
        return isset($this->SocialSubChildItem) ? $this->SocialSubChildItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSocialSubChildItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSocialSubChildItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSocialSubChildItemForArrayConstraintsFromSetSocialSubChildItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSocialSubChildItemSocialSubChildItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfSocialSubChildItemSocialSubChildItemItem instanceof \StructType\SocialSubChildItem) {
                $invalidValues[] = is_object($arrayOfSocialSubChildItemSocialSubChildItemItem) ? get_class($arrayOfSocialSubChildItemSocialSubChildItemItem) : sprintf('%s(%s)', gettype($arrayOfSocialSubChildItemSocialSubChildItemItem), var_export($arrayOfSocialSubChildItemSocialSubChildItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SocialSubChildItem property can only contain items of type \StructType\SocialSubChildItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SocialSubChildItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SocialSubChildItem[] $socialSubChildItem
     * @return \ArrayType\ArrayOfSocialSubChildItem
     */
    public function setSocialSubChildItem(array $socialSubChildItem = array())
    {
        // validation for constraint: array
        if ('' !== ($socialSubChildItemArrayErrorMessage = self::validateSocialSubChildItemForArrayConstraintsFromSetSocialSubChildItem($socialSubChildItem))) {
            throw new \InvalidArgumentException($socialSubChildItemArrayErrorMessage, __LINE__);
        }
        if (is_null($socialSubChildItem) || (is_array($socialSubChildItem) && empty($socialSubChildItem))) {
            unset($this->SocialSubChildItem);
        } else {
            $this->SocialSubChildItem = $socialSubChildItem;
        }
        return $this;
    }
    /**
     * Add item to SocialSubChildItem value
     * @throws \InvalidArgumentException
     * @param \StructType\SocialSubChildItem $item
     * @return \ArrayType\ArrayOfSocialSubChildItem
     */
    public function addToSocialSubChildItem(\StructType\SocialSubChildItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SocialSubChildItem) {
            throw new \InvalidArgumentException(sprintf('The SocialSubChildItem property can only contain items of type \StructType\SocialSubChildItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SocialSubChildItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SocialSubChildItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SocialSubChildItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SocialSubChildItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SocialSubChildItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SocialSubChildItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SocialSubChildItem
     */
    public function getAttributeName()
    {
        return 'SocialSubChildItem';
    }
}
