<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSocialGroupItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfSocialGroupItem extends AbstractStructArrayBase
{
    /**
     * The SocialGroupItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SocialGroupItem[]
     */
    public $SocialGroupItem;
    /**
     * Constructor method for ArrayOfSocialGroupItem
     * @uses ArrayOfSocialGroupItem::setSocialGroupItem()
     * @param \StructType\SocialGroupItem[] $socialGroupItem
     */
    public function __construct(array $socialGroupItem = array())
    {
        $this
            ->setSocialGroupItem($socialGroupItem);
    }
    /**
     * Get SocialGroupItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SocialGroupItem[]|null
     */
    public function getSocialGroupItem()
    {
        return isset($this->SocialGroupItem) ? $this->SocialGroupItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSocialGroupItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSocialGroupItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSocialGroupItemForArrayConstraintsFromSetSocialGroupItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSocialGroupItemSocialGroupItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfSocialGroupItemSocialGroupItemItem instanceof \StructType\SocialGroupItem) {
                $invalidValues[] = is_object($arrayOfSocialGroupItemSocialGroupItemItem) ? get_class($arrayOfSocialGroupItemSocialGroupItemItem) : sprintf('%s(%s)', gettype($arrayOfSocialGroupItemSocialGroupItemItem), var_export($arrayOfSocialGroupItemSocialGroupItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SocialGroupItem property can only contain items of type \StructType\SocialGroupItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SocialGroupItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SocialGroupItem[] $socialGroupItem
     * @return \ArrayType\ArrayOfSocialGroupItem
     */
    public function setSocialGroupItem(array $socialGroupItem = array())
    {
        // validation for constraint: array
        if ('' !== ($socialGroupItemArrayErrorMessage = self::validateSocialGroupItemForArrayConstraintsFromSetSocialGroupItem($socialGroupItem))) {
            throw new \InvalidArgumentException($socialGroupItemArrayErrorMessage, __LINE__);
        }
        if (is_null($socialGroupItem) || (is_array($socialGroupItem) && empty($socialGroupItem))) {
            unset($this->SocialGroupItem);
        } else {
            $this->SocialGroupItem = $socialGroupItem;
        }
        return $this;
    }
    /**
     * Add item to SocialGroupItem value
     * @throws \InvalidArgumentException
     * @param \StructType\SocialGroupItem $item
     * @return \ArrayType\ArrayOfSocialGroupItem
     */
    public function addToSocialGroupItem(\StructType\SocialGroupItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SocialGroupItem) {
            throw new \InvalidArgumentException(sprintf('The SocialGroupItem property can only contain items of type \StructType\SocialGroupItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SocialGroupItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SocialGroupItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SocialGroupItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SocialGroupItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SocialGroupItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SocialGroupItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SocialGroupItem
     */
    public function getAttributeName()
    {
        return 'SocialGroupItem';
    }
}
