<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRegistration_v2 ArrayType
 * @subpackage Arrays
 */
class ArrayOfRegistration_v2 extends AbstractStructArrayBase
{
    /**
     * The Registration_v2
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Registration_v2[]
     */
    public $Registration_v2;
    /**
     * Constructor method for ArrayOfRegistration_v2
     * @uses ArrayOfRegistration_v2::setRegistration_v2()
     * @param \StructType\Registration_v2[] $registration_v2
     */
    public function __construct(array $registration_v2 = array())
    {
        $this
            ->setRegistration_v2($registration_v2);
    }
    /**
     * Get Registration_v2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Registration_v2[]|null
     */
    public function getRegistration_v2()
    {
        return isset($this->Registration_v2) ? $this->Registration_v2 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRegistration_v2 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRegistration_v2 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRegistration_v2ForArrayConstraintsFromSetRegistration_v2(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRegistration_v2Registration_v2Item) {
            // validation for constraint: itemType
            if (!$arrayOfRegistration_v2Registration_v2Item instanceof \StructType\Registration_v2) {
                $invalidValues[] = is_object($arrayOfRegistration_v2Registration_v2Item) ? get_class($arrayOfRegistration_v2Registration_v2Item) : sprintf('%s(%s)', gettype($arrayOfRegistration_v2Registration_v2Item), var_export($arrayOfRegistration_v2Registration_v2Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Registration_v2 property can only contain items of type \StructType\Registration_v2, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Registration_v2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Registration_v2[] $registration_v2
     * @return \ArrayType\ArrayOfRegistration_v2
     */
    public function setRegistration_v2(array $registration_v2 = array())
    {
        // validation for constraint: array
        if ('' !== ($registration_v2ArrayErrorMessage = self::validateRegistration_v2ForArrayConstraintsFromSetRegistration_v2($registration_v2))) {
            throw new \InvalidArgumentException($registration_v2ArrayErrorMessage, __LINE__);
        }
        if (is_null($registration_v2) || (is_array($registration_v2) && empty($registration_v2))) {
            unset($this->Registration_v2);
        } else {
            $this->Registration_v2 = $registration_v2;
        }
        return $this;
    }
    /**
     * Add item to Registration_v2 value
     * @throws \InvalidArgumentException
     * @param \StructType\Registration_v2 $item
     * @return \ArrayType\ArrayOfRegistration_v2
     */
    public function addToRegistration_v2(\StructType\Registration_v2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Registration_v2) {
            throw new \InvalidArgumentException(sprintf('The Registration_v2 property can only contain items of type \StructType\Registration_v2, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Registration_v2[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Registration_v2|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Registration_v2|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Registration_v2|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Registration_v2|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Registration_v2|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Registration_v2
     */
    public function getAttributeName()
    {
        return 'Registration_v2';
    }
}
