<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRegistration ArrayType
 * @subpackage Arrays
 */
class ArrayOfRegistration extends AbstractStructArrayBase
{
    /**
     * The Registration
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Registration[]
     */
    public $Registration;
    /**
     * Constructor method for ArrayOfRegistration
     * @uses ArrayOfRegistration::setRegistration()
     * @param \StructType\Registration[] $registration
     */
    public function __construct(array $registration = array())
    {
        $this
            ->setRegistration($registration);
    }
    /**
     * Get Registration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Registration[]|null
     */
    public function getRegistration()
    {
        return isset($this->Registration) ? $this->Registration : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRegistration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRegistration method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRegistrationForArrayConstraintsFromSetRegistration(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRegistrationRegistrationItem) {
            // validation for constraint: itemType
            if (!$arrayOfRegistrationRegistrationItem instanceof \StructType\Registration) {
                $invalidValues[] = is_object($arrayOfRegistrationRegistrationItem) ? get_class($arrayOfRegistrationRegistrationItem) : sprintf('%s(%s)', gettype($arrayOfRegistrationRegistrationItem), var_export($arrayOfRegistrationRegistrationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Registration property can only contain items of type \StructType\Registration, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Registration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Registration[] $registration
     * @return \ArrayType\ArrayOfRegistration
     */
    public function setRegistration(array $registration = array())
    {
        // validation for constraint: array
        if ('' !== ($registrationArrayErrorMessage = self::validateRegistrationForArrayConstraintsFromSetRegistration($registration))) {
            throw new \InvalidArgumentException($registrationArrayErrorMessage, __LINE__);
        }
        if (is_null($registration) || (is_array($registration) && empty($registration))) {
            unset($this->Registration);
        } else {
            $this->Registration = $registration;
        }
        return $this;
    }
    /**
     * Add item to Registration value
     * @throws \InvalidArgumentException
     * @param \StructType\Registration $item
     * @return \ArrayType\ArrayOfRegistration
     */
    public function addToRegistration(\StructType\Registration $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Registration) {
            throw new \InvalidArgumentException(sprintf('The Registration property can only contain items of type \StructType\Registration, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Registration[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Registration|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Registration|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Registration|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Registration|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Registration|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Registration
     */
    public function getAttributeName()
    {
        return 'Registration';
    }
}
