<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfReferenceItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfReferenceItem extends AbstractStructArrayBase
{
    /**
     * The ReferenceItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ReferenceItem[]
     */
    public $ReferenceItem;
    /**
     * Constructor method for ArrayOfReferenceItem
     * @uses ArrayOfReferenceItem::setReferenceItem()
     * @param \StructType\ReferenceItem[] $referenceItem
     */
    public function __construct(array $referenceItem = array())
    {
        $this
            ->setReferenceItem($referenceItem);
    }
    /**
     * Get ReferenceItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ReferenceItem[]|null
     */
    public function getReferenceItem()
    {
        return isset($this->ReferenceItem) ? $this->ReferenceItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setReferenceItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReferenceItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenceItemForArrayConstraintsFromSetReferenceItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfReferenceItemReferenceItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfReferenceItemReferenceItemItem instanceof \StructType\ReferenceItem) {
                $invalidValues[] = is_object($arrayOfReferenceItemReferenceItemItem) ? get_class($arrayOfReferenceItemReferenceItemItem) : sprintf('%s(%s)', gettype($arrayOfReferenceItemReferenceItemItem), var_export($arrayOfReferenceItemReferenceItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReferenceItem property can only contain items of type \StructType\ReferenceItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReferenceItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ReferenceItem[] $referenceItem
     * @return \ArrayType\ArrayOfReferenceItem
     */
    public function setReferenceItem(array $referenceItem = array())
    {
        // validation for constraint: array
        if ('' !== ($referenceItemArrayErrorMessage = self::validateReferenceItemForArrayConstraintsFromSetReferenceItem($referenceItem))) {
            throw new \InvalidArgumentException($referenceItemArrayErrorMessage, __LINE__);
        }
        if (is_null($referenceItem) || (is_array($referenceItem) && empty($referenceItem))) {
            unset($this->ReferenceItem);
        } else {
            $this->ReferenceItem = $referenceItem;
        }
        return $this;
    }
    /**
     * Add item to ReferenceItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ReferenceItem $item
     * @return \ArrayType\ArrayOfReferenceItem
     */
    public function addToReferenceItem(\StructType\ReferenceItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReferenceItem) {
            throw new \InvalidArgumentException(sprintf('The ReferenceItem property can only contain items of type \StructType\ReferenceItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReferenceItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ReferenceItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ReferenceItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ReferenceItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ReferenceItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ReferenceItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ReferenceItem
     */
    public function getAttributeName()
    {
        return 'ReferenceItem';
    }
}
