<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRPMAndDurationItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfRPMAndDurationItem extends AbstractStructArrayBase
{
    /**
     * The RPMAndDurationItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RPMAndDurationItem[]
     */
    public $RPMAndDurationItem;
    /**
     * Constructor method for ArrayOfRPMAndDurationItem
     * @uses ArrayOfRPMAndDurationItem::setRPMAndDurationItem()
     * @param \StructType\RPMAndDurationItem[] $rPMAndDurationItem
     */
    public function __construct(array $rPMAndDurationItem = array())
    {
        $this
            ->setRPMAndDurationItem($rPMAndDurationItem);
    }
    /**
     * Get RPMAndDurationItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RPMAndDurationItem[]|null
     */
    public function getRPMAndDurationItem()
    {
        return isset($this->RPMAndDurationItem) ? $this->RPMAndDurationItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRPMAndDurationItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRPMAndDurationItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRPMAndDurationItemForArrayConstraintsFromSetRPMAndDurationItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRPMAndDurationItemRPMAndDurationItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfRPMAndDurationItemRPMAndDurationItemItem instanceof \StructType\RPMAndDurationItem) {
                $invalidValues[] = is_object($arrayOfRPMAndDurationItemRPMAndDurationItemItem) ? get_class($arrayOfRPMAndDurationItemRPMAndDurationItemItem) : sprintf('%s(%s)', gettype($arrayOfRPMAndDurationItemRPMAndDurationItemItem), var_export($arrayOfRPMAndDurationItemRPMAndDurationItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RPMAndDurationItem property can only contain items of type \StructType\RPMAndDurationItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RPMAndDurationItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RPMAndDurationItem[] $rPMAndDurationItem
     * @return \ArrayType\ArrayOfRPMAndDurationItem
     */
    public function setRPMAndDurationItem(array $rPMAndDurationItem = array())
    {
        // validation for constraint: array
        if ('' !== ($rPMAndDurationItemArrayErrorMessage = self::validateRPMAndDurationItemForArrayConstraintsFromSetRPMAndDurationItem($rPMAndDurationItem))) {
            throw new \InvalidArgumentException($rPMAndDurationItemArrayErrorMessage, __LINE__);
        }
        if (is_null($rPMAndDurationItem) || (is_array($rPMAndDurationItem) && empty($rPMAndDurationItem))) {
            unset($this->RPMAndDurationItem);
        } else {
            $this->RPMAndDurationItem = $rPMAndDurationItem;
        }
        return $this;
    }
    /**
     * Add item to RPMAndDurationItem value
     * @throws \InvalidArgumentException
     * @param \StructType\RPMAndDurationItem $item
     * @return \ArrayType\ArrayOfRPMAndDurationItem
     */
    public function addToRPMAndDurationItem(\StructType\RPMAndDurationItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RPMAndDurationItem) {
            throw new \InvalidArgumentException(sprintf('The RPMAndDurationItem property can only contain items of type \StructType\RPMAndDurationItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RPMAndDurationItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RPMAndDurationItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RPMAndDurationItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RPMAndDurationItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RPMAndDurationItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RPMAndDurationItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RPMAndDurationItem
     */
    public function getAttributeName()
    {
        return 'RPMAndDurationItem';
    }
}
