<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProfileItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfProfileItem extends AbstractStructArrayBase
{
    /**
     * The ProfileItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProfileItem[]
     */
    public $ProfileItem;
    /**
     * Constructor method for ArrayOfProfileItem
     * @uses ArrayOfProfileItem::setProfileItem()
     * @param \StructType\ProfileItem[] $profileItem
     */
    public function __construct(array $profileItem = array())
    {
        $this
            ->setProfileItem($profileItem);
    }
    /**
     * Get ProfileItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProfileItem[]|null
     */
    public function getProfileItem()
    {
        return isset($this->ProfileItem) ? $this->ProfileItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProfileItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProfileItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProfileItemForArrayConstraintsFromSetProfileItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfProfileItemProfileItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfProfileItemProfileItemItem instanceof \StructType\ProfileItem) {
                $invalidValues[] = is_object($arrayOfProfileItemProfileItemItem) ? get_class($arrayOfProfileItemProfileItemItem) : sprintf('%s(%s)', gettype($arrayOfProfileItemProfileItemItem), var_export($arrayOfProfileItemProfileItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProfileItem property can only contain items of type \StructType\ProfileItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProfileItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProfileItem[] $profileItem
     * @return \ArrayType\ArrayOfProfileItem
     */
    public function setProfileItem(array $profileItem = array())
    {
        // validation for constraint: array
        if ('' !== ($profileItemArrayErrorMessage = self::validateProfileItemForArrayConstraintsFromSetProfileItem($profileItem))) {
            throw new \InvalidArgumentException($profileItemArrayErrorMessage, __LINE__);
        }
        if (is_null($profileItem) || (is_array($profileItem) && empty($profileItem))) {
            unset($this->ProfileItem);
        } else {
            $this->ProfileItem = $profileItem;
        }
        return $this;
    }
    /**
     * Add item to ProfileItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ProfileItem $item
     * @return \ArrayType\ArrayOfProfileItem
     */
    public function addToProfileItem(\StructType\ProfileItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProfileItem) {
            throw new \InvalidArgumentException(sprintf('The ProfileItem property can only contain items of type \StructType\ProfileItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProfileItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProfileItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProfileItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProfileItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProfileItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProfileItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProfileItem
     */
    public function getAttributeName()
    {
        return 'ProfileItem';
    }
}
