<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductItemResult_V4 ArrayType
 * @subpackage Arrays
 */
class ArrayOfProductItemResult_V4 extends AbstractStructArrayBase
{
    /**
     * The ProductItemResult_V4
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProductItemResult_V4[]
     */
    public $ProductItemResult_V4;
    /**
     * Constructor method for ArrayOfProductItemResult_V4
     * @uses ArrayOfProductItemResult_V4::setProductItemResult_V4()
     * @param \StructType\ProductItemResult_V4[] $productItemResult_V4
     */
    public function __construct(array $productItemResult_V4 = array())
    {
        $this
            ->setProductItemResult_V4($productItemResult_V4);
    }
    /**
     * Get ProductItemResult_V4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProductItemResult_V4[]|null
     */
    public function getProductItemResult_V4()
    {
        return isset($this->ProductItemResult_V4) ? $this->ProductItemResult_V4 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProductItemResult_V4 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductItemResult_V4 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductItemResult_V4ForArrayConstraintsFromSetProductItemResult_V4(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfProductItemResult_V4ProductItemResult_V4Item) {
            // validation for constraint: itemType
            if (!$arrayOfProductItemResult_V4ProductItemResult_V4Item instanceof \StructType\ProductItemResult_V4) {
                $invalidValues[] = is_object($arrayOfProductItemResult_V4ProductItemResult_V4Item) ? get_class($arrayOfProductItemResult_V4ProductItemResult_V4Item) : sprintf('%s(%s)', gettype($arrayOfProductItemResult_V4ProductItemResult_V4Item), var_export($arrayOfProductItemResult_V4ProductItemResult_V4Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProductItemResult_V4 property can only contain items of type \StructType\ProductItemResult_V4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProductItemResult_V4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProductItemResult_V4[] $productItemResult_V4
     * @return \ArrayType\ArrayOfProductItemResult_V4
     */
    public function setProductItemResult_V4(array $productItemResult_V4 = array())
    {
        // validation for constraint: array
        if ('' !== ($productItemResult_V4ArrayErrorMessage = self::validateProductItemResult_V4ForArrayConstraintsFromSetProductItemResult_V4($productItemResult_V4))) {
            throw new \InvalidArgumentException($productItemResult_V4ArrayErrorMessage, __LINE__);
        }
        if (is_null($productItemResult_V4) || (is_array($productItemResult_V4) && empty($productItemResult_V4))) {
            unset($this->ProductItemResult_V4);
        } else {
            $this->ProductItemResult_V4 = $productItemResult_V4;
        }
        return $this;
    }
    /**
     * Add item to ProductItemResult_V4 value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductItemResult_V4 $item
     * @return \ArrayType\ArrayOfProductItemResult_V4
     */
    public function addToProductItemResult_V4(\StructType\ProductItemResult_V4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductItemResult_V4) {
            throw new \InvalidArgumentException(sprintf('The ProductItemResult_V4 property can only contain items of type \StructType\ProductItemResult_V4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProductItemResult_V4[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductItemResult_V4|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductItemResult_V4|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductItemResult_V4|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductItemResult_V4|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductItemResult_V4|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductItemResult_V4
     */
    public function getAttributeName()
    {
        return 'ProductItemResult_V4';
    }
}
