<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPositionItemResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfPositionItemResult extends AbstractStructArrayBase
{
    /**
     * The PositionItemResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PositionItemResult[]
     */
    public $PositionItemResult;
    /**
     * Constructor method for ArrayOfPositionItemResult
     * @uses ArrayOfPositionItemResult::setPositionItemResult()
     * @param \StructType\PositionItemResult[] $positionItemResult
     */
    public function __construct(array $positionItemResult = array())
    {
        $this
            ->setPositionItemResult($positionItemResult);
    }
    /**
     * Get PositionItemResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PositionItemResult[]|null
     */
    public function getPositionItemResult()
    {
        return isset($this->PositionItemResult) ? $this->PositionItemResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPositionItemResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPositionItemResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePositionItemResultForArrayConstraintsFromSetPositionItemResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPositionItemResultPositionItemResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfPositionItemResultPositionItemResultItem instanceof \StructType\PositionItemResult) {
                $invalidValues[] = is_object($arrayOfPositionItemResultPositionItemResultItem) ? get_class($arrayOfPositionItemResultPositionItemResultItem) : sprintf('%s(%s)', gettype($arrayOfPositionItemResultPositionItemResultItem), var_export($arrayOfPositionItemResultPositionItemResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PositionItemResult property can only contain items of type \StructType\PositionItemResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PositionItemResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PositionItemResult[] $positionItemResult
     * @return \ArrayType\ArrayOfPositionItemResult
     */
    public function setPositionItemResult(array $positionItemResult = array())
    {
        // validation for constraint: array
        if ('' !== ($positionItemResultArrayErrorMessage = self::validatePositionItemResultForArrayConstraintsFromSetPositionItemResult($positionItemResult))) {
            throw new \InvalidArgumentException($positionItemResultArrayErrorMessage, __LINE__);
        }
        if (is_null($positionItemResult) || (is_array($positionItemResult) && empty($positionItemResult))) {
            unset($this->PositionItemResult);
        } else {
            $this->PositionItemResult = $positionItemResult;
        }
        return $this;
    }
    /**
     * Add item to PositionItemResult value
     * @throws \InvalidArgumentException
     * @param \StructType\PositionItemResult $item
     * @return \ArrayType\ArrayOfPositionItemResult
     */
    public function addToPositionItemResult(\StructType\PositionItemResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PositionItemResult) {
            throw new \InvalidArgumentException(sprintf('The PositionItemResult property can only contain items of type \StructType\PositionItemResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PositionItemResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PositionItemResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PositionItemResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PositionItemResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PositionItemResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PositionItemResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PositionItemResult
     */
    public function getAttributeName()
    {
        return 'PositionItemResult';
    }
}
