<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPlanningTripItemResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfPlanningTripItemResult extends AbstractStructArrayBase
{
    /**
     * The PlanningTripItemResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PlanningTripItemResult[]
     */
    public $PlanningTripItemResult;
    /**
     * Constructor method for ArrayOfPlanningTripItemResult
     * @uses ArrayOfPlanningTripItemResult::setPlanningTripItemResult()
     * @param \StructType\PlanningTripItemResult[] $planningTripItemResult
     */
    public function __construct(array $planningTripItemResult = array())
    {
        $this
            ->setPlanningTripItemResult($planningTripItemResult);
    }
    /**
     * Get PlanningTripItemResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PlanningTripItemResult[]|null
     */
    public function getPlanningTripItemResult()
    {
        return isset($this->PlanningTripItemResult) ? $this->PlanningTripItemResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPlanningTripItemResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPlanningTripItemResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePlanningTripItemResultForArrayConstraintsFromSetPlanningTripItemResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPlanningTripItemResultPlanningTripItemResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfPlanningTripItemResultPlanningTripItemResultItem instanceof \StructType\PlanningTripItemResult) {
                $invalidValues[] = is_object($arrayOfPlanningTripItemResultPlanningTripItemResultItem) ? get_class($arrayOfPlanningTripItemResultPlanningTripItemResultItem) : sprintf('%s(%s)', gettype($arrayOfPlanningTripItemResultPlanningTripItemResultItem), var_export($arrayOfPlanningTripItemResultPlanningTripItemResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PlanningTripItemResult property can only contain items of type \StructType\PlanningTripItemResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PlanningTripItemResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PlanningTripItemResult[] $planningTripItemResult
     * @return \ArrayType\ArrayOfPlanningTripItemResult
     */
    public function setPlanningTripItemResult(array $planningTripItemResult = array())
    {
        // validation for constraint: array
        if ('' !== ($planningTripItemResultArrayErrorMessage = self::validatePlanningTripItemResultForArrayConstraintsFromSetPlanningTripItemResult($planningTripItemResult))) {
            throw new \InvalidArgumentException($planningTripItemResultArrayErrorMessage, __LINE__);
        }
        if (is_null($planningTripItemResult) || (is_array($planningTripItemResult) && empty($planningTripItemResult))) {
            unset($this->PlanningTripItemResult);
        } else {
            $this->PlanningTripItemResult = $planningTripItemResult;
        }
        return $this;
    }
    /**
     * Add item to PlanningTripItemResult value
     * @throws \InvalidArgumentException
     * @param \StructType\PlanningTripItemResult $item
     * @return \ArrayType\ArrayOfPlanningTripItemResult
     */
    public function addToPlanningTripItemResult(\StructType\PlanningTripItemResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PlanningTripItemResult) {
            throw new \InvalidArgumentException(sprintf('The PlanningTripItemResult property can only contain items of type \StructType\PlanningTripItemResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PlanningTripItemResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PlanningTripItemResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PlanningTripItemResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PlanningTripItemResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PlanningTripItemResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PlanningTripItemResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PlanningTripItemResult
     */
    public function getAttributeName()
    {
        return 'PlanningTripItemResult';
    }
}
