<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPlanningResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfPlanningResult extends AbstractStructArrayBase
{
    /**
     * The PlanningResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PlanningResult[]
     */
    public $PlanningResult;
    /**
     * Constructor method for ArrayOfPlanningResult
     * @uses ArrayOfPlanningResult::setPlanningResult()
     * @param \StructType\PlanningResult[] $planningResult
     */
    public function __construct(array $planningResult = array())
    {
        $this
            ->setPlanningResult($planningResult);
    }
    /**
     * Get PlanningResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PlanningResult[]|null
     */
    public function getPlanningResult()
    {
        return isset($this->PlanningResult) ? $this->PlanningResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPlanningResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPlanningResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePlanningResultForArrayConstraintsFromSetPlanningResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPlanningResultPlanningResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfPlanningResultPlanningResultItem instanceof \StructType\PlanningResult) {
                $invalidValues[] = is_object($arrayOfPlanningResultPlanningResultItem) ? get_class($arrayOfPlanningResultPlanningResultItem) : sprintf('%s(%s)', gettype($arrayOfPlanningResultPlanningResultItem), var_export($arrayOfPlanningResultPlanningResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PlanningResult property can only contain items of type \StructType\PlanningResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PlanningResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PlanningResult[] $planningResult
     * @return \ArrayType\ArrayOfPlanningResult
     */
    public function setPlanningResult(array $planningResult = array())
    {
        // validation for constraint: array
        if ('' !== ($planningResultArrayErrorMessage = self::validatePlanningResultForArrayConstraintsFromSetPlanningResult($planningResult))) {
            throw new \InvalidArgumentException($planningResultArrayErrorMessage, __LINE__);
        }
        if (is_null($planningResult) || (is_array($planningResult) && empty($planningResult))) {
            unset($this->PlanningResult);
        } else {
            $this->PlanningResult = $planningResult;
        }
        return $this;
    }
    /**
     * Add item to PlanningResult value
     * @throws \InvalidArgumentException
     * @param \StructType\PlanningResult $item
     * @return \ArrayType\ArrayOfPlanningResult
     */
    public function addToPlanningResult(\StructType\PlanningResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PlanningResult) {
            throw new \InvalidArgumentException(sprintf('The PlanningResult property can only contain items of type \StructType\PlanningResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PlanningResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PlanningResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PlanningResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PlanningResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PlanningResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PlanningResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PlanningResult
     */
    public function getAttributeName()
    {
        return 'PlanningResult';
    }
}
