<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPlanningConfigItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfPlanningConfigItem extends AbstractStructArrayBase
{
    /**
     * The PlanningConfigItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PlanningConfigItem[]
     */
    public $PlanningConfigItem;
    /**
     * Constructor method for ArrayOfPlanningConfigItem
     * @uses ArrayOfPlanningConfigItem::setPlanningConfigItem()
     * @param \StructType\PlanningConfigItem[] $planningConfigItem
     */
    public function __construct(array $planningConfigItem = array())
    {
        $this
            ->setPlanningConfigItem($planningConfigItem);
    }
    /**
     * Get PlanningConfigItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PlanningConfigItem[]|null
     */
    public function getPlanningConfigItem()
    {
        return isset($this->PlanningConfigItem) ? $this->PlanningConfigItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPlanningConfigItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPlanningConfigItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePlanningConfigItemForArrayConstraintsFromSetPlanningConfigItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPlanningConfigItemPlanningConfigItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfPlanningConfigItemPlanningConfigItemItem instanceof \StructType\PlanningConfigItem) {
                $invalidValues[] = is_object($arrayOfPlanningConfigItemPlanningConfigItemItem) ? get_class($arrayOfPlanningConfigItemPlanningConfigItemItem) : sprintf('%s(%s)', gettype($arrayOfPlanningConfigItemPlanningConfigItemItem), var_export($arrayOfPlanningConfigItemPlanningConfigItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PlanningConfigItem property can only contain items of type \StructType\PlanningConfigItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PlanningConfigItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PlanningConfigItem[] $planningConfigItem
     * @return \ArrayType\ArrayOfPlanningConfigItem
     */
    public function setPlanningConfigItem(array $planningConfigItem = array())
    {
        // validation for constraint: array
        if ('' !== ($planningConfigItemArrayErrorMessage = self::validatePlanningConfigItemForArrayConstraintsFromSetPlanningConfigItem($planningConfigItem))) {
            throw new \InvalidArgumentException($planningConfigItemArrayErrorMessage, __LINE__);
        }
        if (is_null($planningConfigItem) || (is_array($planningConfigItem) && empty($planningConfigItem))) {
            unset($this->PlanningConfigItem);
        } else {
            $this->PlanningConfigItem = $planningConfigItem;
        }
        return $this;
    }
    /**
     * Add item to PlanningConfigItem value
     * @throws \InvalidArgumentException
     * @param \StructType\PlanningConfigItem $item
     * @return \ArrayType\ArrayOfPlanningConfigItem
     */
    public function addToPlanningConfigItem(\StructType\PlanningConfigItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PlanningConfigItem) {
            throw new \InvalidArgumentException(sprintf('The PlanningConfigItem property can only contain items of type \StructType\PlanningConfigItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PlanningConfigItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PlanningConfigItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PlanningConfigItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PlanningConfigItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PlanningConfigItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PlanningConfigItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PlanningConfigItem
     */
    public function getAttributeName()
    {
        return 'PlanningConfigItem';
    }
}
