<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPlaceItemResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfPlaceItemResult extends AbstractStructArrayBase
{
    /**
     * The PlaceItemResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PlaceItemResult[]
     */
    public $PlaceItemResult;
    /**
     * Constructor method for ArrayOfPlaceItemResult
     * @uses ArrayOfPlaceItemResult::setPlaceItemResult()
     * @param \StructType\PlaceItemResult[] $placeItemResult
     */
    public function __construct(array $placeItemResult = array())
    {
        $this
            ->setPlaceItemResult($placeItemResult);
    }
    /**
     * Get PlaceItemResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PlaceItemResult[]|null
     */
    public function getPlaceItemResult()
    {
        return isset($this->PlaceItemResult) ? $this->PlaceItemResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPlaceItemResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPlaceItemResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePlaceItemResultForArrayConstraintsFromSetPlaceItemResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPlaceItemResultPlaceItemResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfPlaceItemResultPlaceItemResultItem instanceof \StructType\PlaceItemResult) {
                $invalidValues[] = is_object($arrayOfPlaceItemResultPlaceItemResultItem) ? get_class($arrayOfPlaceItemResultPlaceItemResultItem) : sprintf('%s(%s)', gettype($arrayOfPlaceItemResultPlaceItemResultItem), var_export($arrayOfPlaceItemResultPlaceItemResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PlaceItemResult property can only contain items of type \StructType\PlaceItemResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PlaceItemResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PlaceItemResult[] $placeItemResult
     * @return \ArrayType\ArrayOfPlaceItemResult
     */
    public function setPlaceItemResult(array $placeItemResult = array())
    {
        // validation for constraint: array
        if ('' !== ($placeItemResultArrayErrorMessage = self::validatePlaceItemResultForArrayConstraintsFromSetPlaceItemResult($placeItemResult))) {
            throw new \InvalidArgumentException($placeItemResultArrayErrorMessage, __LINE__);
        }
        if (is_null($placeItemResult) || (is_array($placeItemResult) && empty($placeItemResult))) {
            unset($this->PlaceItemResult);
        } else {
            $this->PlaceItemResult = $placeItemResult;
        }
        return $this;
    }
    /**
     * Add item to PlaceItemResult value
     * @throws \InvalidArgumentException
     * @param \StructType\PlaceItemResult $item
     * @return \ArrayType\ArrayOfPlaceItemResult
     */
    public function addToPlaceItemResult(\StructType\PlaceItemResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PlaceItemResult) {
            throw new \InvalidArgumentException(sprintf('The PlaceItemResult property can only contain items of type \StructType\PlaceItemResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PlaceItemResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PlaceItemResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PlaceItemResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PlaceItemResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PlaceItemResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PlaceItemResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PlaceItemResult
     */
    public function getAttributeName()
    {
        return 'PlaceItemResult';
    }
}
