<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPersonalCommunication ArrayType
 * @subpackage Arrays
 */
class ArrayOfPersonalCommunication extends AbstractStructArrayBase
{
    /**
     * The PersonalCommunication
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PersonalCommunication[]
     */
    public $PersonalCommunication;
    /**
     * Constructor method for ArrayOfPersonalCommunication
     * @uses ArrayOfPersonalCommunication::setPersonalCommunication()
     * @param \StructType\PersonalCommunication[] $personalCommunication
     */
    public function __construct(array $personalCommunication = array())
    {
        $this
            ->setPersonalCommunication($personalCommunication);
    }
    /**
     * Get PersonalCommunication value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PersonalCommunication[]|null
     */
    public function getPersonalCommunication()
    {
        return isset($this->PersonalCommunication) ? $this->PersonalCommunication : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPersonalCommunication method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonalCommunication method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePersonalCommunicationForArrayConstraintsFromSetPersonalCommunication(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPersonalCommunicationPersonalCommunicationItem) {
            // validation for constraint: itemType
            if (!$arrayOfPersonalCommunicationPersonalCommunicationItem instanceof \StructType\PersonalCommunication) {
                $invalidValues[] = is_object($arrayOfPersonalCommunicationPersonalCommunicationItem) ? get_class($arrayOfPersonalCommunicationPersonalCommunicationItem) : sprintf('%s(%s)', gettype($arrayOfPersonalCommunicationPersonalCommunicationItem), var_export($arrayOfPersonalCommunicationPersonalCommunicationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PersonalCommunication property can only contain items of type \StructType\PersonalCommunication, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PersonalCommunication value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PersonalCommunication[] $personalCommunication
     * @return \ArrayType\ArrayOfPersonalCommunication
     */
    public function setPersonalCommunication(array $personalCommunication = array())
    {
        // validation for constraint: array
        if ('' !== ($personalCommunicationArrayErrorMessage = self::validatePersonalCommunicationForArrayConstraintsFromSetPersonalCommunication($personalCommunication))) {
            throw new \InvalidArgumentException($personalCommunicationArrayErrorMessage, __LINE__);
        }
        if (is_null($personalCommunication) || (is_array($personalCommunication) && empty($personalCommunication))) {
            unset($this->PersonalCommunication);
        } else {
            $this->PersonalCommunication = $personalCommunication;
        }
        return $this;
    }
    /**
     * Add item to PersonalCommunication value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonalCommunication $item
     * @return \ArrayType\ArrayOfPersonalCommunication
     */
    public function addToPersonalCommunication(\StructType\PersonalCommunication $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PersonalCommunication) {
            throw new \InvalidArgumentException(sprintf('The PersonalCommunication property can only contain items of type \StructType\PersonalCommunication, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PersonalCommunication[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PersonalCommunication|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PersonalCommunication|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PersonalCommunication|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PersonalCommunication|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PersonalCommunication|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PersonalCommunication
     */
    public function getAttributeName()
    {
        return 'PersonalCommunication';
    }
}
