<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPersonResult_V4 ArrayType
 * @subpackage Arrays
 */
class ArrayOfPersonResult_V4 extends AbstractStructArrayBase
{
    /**
     * The PersonResult_V4
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PersonResult_V4[]
     */
    public $PersonResult_V4;
    /**
     * Constructor method for ArrayOfPersonResult_V4
     * @uses ArrayOfPersonResult_V4::setPersonResult_V4()
     * @param \StructType\PersonResult_V4[] $personResult_V4
     */
    public function __construct(array $personResult_V4 = array())
    {
        $this
            ->setPersonResult_V4($personResult_V4);
    }
    /**
     * Get PersonResult_V4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PersonResult_V4[]|null
     */
    public function getPersonResult_V4()
    {
        return isset($this->PersonResult_V4) ? $this->PersonResult_V4 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPersonResult_V4 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonResult_V4 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePersonResult_V4ForArrayConstraintsFromSetPersonResult_V4(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPersonResult_V4PersonResult_V4Item) {
            // validation for constraint: itemType
            if (!$arrayOfPersonResult_V4PersonResult_V4Item instanceof \StructType\PersonResult_V4) {
                $invalidValues[] = is_object($arrayOfPersonResult_V4PersonResult_V4Item) ? get_class($arrayOfPersonResult_V4PersonResult_V4Item) : sprintf('%s(%s)', gettype($arrayOfPersonResult_V4PersonResult_V4Item), var_export($arrayOfPersonResult_V4PersonResult_V4Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PersonResult_V4 property can only contain items of type \StructType\PersonResult_V4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PersonResult_V4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PersonResult_V4[] $personResult_V4
     * @return \ArrayType\ArrayOfPersonResult_V4
     */
    public function setPersonResult_V4(array $personResult_V4 = array())
    {
        // validation for constraint: array
        if ('' !== ($personResult_V4ArrayErrorMessage = self::validatePersonResult_V4ForArrayConstraintsFromSetPersonResult_V4($personResult_V4))) {
            throw new \InvalidArgumentException($personResult_V4ArrayErrorMessage, __LINE__);
        }
        if (is_null($personResult_V4) || (is_array($personResult_V4) && empty($personResult_V4))) {
            unset($this->PersonResult_V4);
        } else {
            $this->PersonResult_V4 = $personResult_V4;
        }
        return $this;
    }
    /**
     * Add item to PersonResult_V4 value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonResult_V4 $item
     * @return \ArrayType\ArrayOfPersonResult_V4
     */
    public function addToPersonResult_V4(\StructType\PersonResult_V4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PersonResult_V4) {
            throw new \InvalidArgumentException(sprintf('The PersonResult_V4 property can only contain items of type \StructType\PersonResult_V4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PersonResult_V4[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PersonResult_V4|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PersonResult_V4|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PersonResult_V4|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PersonResult_V4|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PersonResult_V4|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PersonResult_V4
     */
    public function getAttributeName()
    {
        return 'PersonResult_V4';
    }
}
