<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPersonResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfPersonResult extends AbstractStructArrayBase
{
    /**
     * The PersonResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PersonResult[]
     */
    public $PersonResult;
    /**
     * Constructor method for ArrayOfPersonResult
     * @uses ArrayOfPersonResult::setPersonResult()
     * @param \StructType\PersonResult[] $personResult
     */
    public function __construct(array $personResult = array())
    {
        $this
            ->setPersonResult($personResult);
    }
    /**
     * Get PersonResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PersonResult[]|null
     */
    public function getPersonResult()
    {
        return isset($this->PersonResult) ? $this->PersonResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPersonResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePersonResultForArrayConstraintsFromSetPersonResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPersonResultPersonResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfPersonResultPersonResultItem instanceof \StructType\PersonResult) {
                $invalidValues[] = is_object($arrayOfPersonResultPersonResultItem) ? get_class($arrayOfPersonResultPersonResultItem) : sprintf('%s(%s)', gettype($arrayOfPersonResultPersonResultItem), var_export($arrayOfPersonResultPersonResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PersonResult property can only contain items of type \StructType\PersonResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PersonResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PersonResult[] $personResult
     * @return \ArrayType\ArrayOfPersonResult
     */
    public function setPersonResult(array $personResult = array())
    {
        // validation for constraint: array
        if ('' !== ($personResultArrayErrorMessage = self::validatePersonResultForArrayConstraintsFromSetPersonResult($personResult))) {
            throw new \InvalidArgumentException($personResultArrayErrorMessage, __LINE__);
        }
        if (is_null($personResult) || (is_array($personResult) && empty($personResult))) {
            unset($this->PersonResult);
        } else {
            $this->PersonResult = $personResult;
        }
        return $this;
    }
    /**
     * Add item to PersonResult value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonResult $item
     * @return \ArrayType\ArrayOfPersonResult
     */
    public function addToPersonResult(\StructType\PersonResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PersonResult) {
            throw new \InvalidArgumentException(sprintf('The PersonResult property can only contain items of type \StructType\PersonResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PersonResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PersonResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PersonResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PersonResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PersonResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PersonResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PersonResult
     */
    public function getAttributeName()
    {
        return 'PersonResult';
    }
}
