<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPathResultV2 ArrayType
 * @subpackage Arrays
 */
class ArrayOfPathResultV2 extends AbstractStructArrayBase
{
    /**
     * The PathResultV2
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PathResultV2[]
     */
    public $PathResultV2;
    /**
     * Constructor method for ArrayOfPathResultV2
     * @uses ArrayOfPathResultV2::setPathResultV2()
     * @param \StructType\PathResultV2[] $pathResultV2
     */
    public function __construct(array $pathResultV2 = array())
    {
        $this
            ->setPathResultV2($pathResultV2);
    }
    /**
     * Get PathResultV2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PathResultV2[]|null
     */
    public function getPathResultV2()
    {
        return isset($this->PathResultV2) ? $this->PathResultV2 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPathResultV2 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPathResultV2 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePathResultV2ForArrayConstraintsFromSetPathResultV2(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPathResultV2PathResultV2Item) {
            // validation for constraint: itemType
            if (!$arrayOfPathResultV2PathResultV2Item instanceof \StructType\PathResultV2) {
                $invalidValues[] = is_object($arrayOfPathResultV2PathResultV2Item) ? get_class($arrayOfPathResultV2PathResultV2Item) : sprintf('%s(%s)', gettype($arrayOfPathResultV2PathResultV2Item), var_export($arrayOfPathResultV2PathResultV2Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PathResultV2 property can only contain items of type \StructType\PathResultV2, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PathResultV2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PathResultV2[] $pathResultV2
     * @return \ArrayType\ArrayOfPathResultV2
     */
    public function setPathResultV2(array $pathResultV2 = array())
    {
        // validation for constraint: array
        if ('' !== ($pathResultV2ArrayErrorMessage = self::validatePathResultV2ForArrayConstraintsFromSetPathResultV2($pathResultV2))) {
            throw new \InvalidArgumentException($pathResultV2ArrayErrorMessage, __LINE__);
        }
        if (is_null($pathResultV2) || (is_array($pathResultV2) && empty($pathResultV2))) {
            unset($this->PathResultV2);
        } else {
            $this->PathResultV2 = $pathResultV2;
        }
        return $this;
    }
    /**
     * Add item to PathResultV2 value
     * @throws \InvalidArgumentException
     * @param \StructType\PathResultV2 $item
     * @return \ArrayType\ArrayOfPathResultV2
     */
    public function addToPathResultV2(\StructType\PathResultV2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PathResultV2) {
            throw new \InvalidArgumentException(sprintf('The PathResultV2 property can only contain items of type \StructType\PathResultV2, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PathResultV2[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PathResultV2|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PathResultV2|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PathResultV2|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PathResultV2|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PathResultV2|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PathResultV2
     */
    public function getAttributeName()
    {
        return 'PathResultV2';
    }
}
