<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPathResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfPathResult extends AbstractStructArrayBase
{
    /**
     * The PathResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PathResult[]
     */
    public $PathResult;
    /**
     * Constructor method for ArrayOfPathResult
     * @uses ArrayOfPathResult::setPathResult()
     * @param \StructType\PathResult[] $pathResult
     */
    public function __construct(array $pathResult = array())
    {
        $this
            ->setPathResult($pathResult);
    }
    /**
     * Get PathResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PathResult[]|null
     */
    public function getPathResult()
    {
        return isset($this->PathResult) ? $this->PathResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPathResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPathResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePathResultForArrayConstraintsFromSetPathResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPathResultPathResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfPathResultPathResultItem instanceof \StructType\PathResult) {
                $invalidValues[] = is_object($arrayOfPathResultPathResultItem) ? get_class($arrayOfPathResultPathResultItem) : sprintf('%s(%s)', gettype($arrayOfPathResultPathResultItem), var_export($arrayOfPathResultPathResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PathResult property can only contain items of type \StructType\PathResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PathResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PathResult[] $pathResult
     * @return \ArrayType\ArrayOfPathResult
     */
    public function setPathResult(array $pathResult = array())
    {
        // validation for constraint: array
        if ('' !== ($pathResultArrayErrorMessage = self::validatePathResultForArrayConstraintsFromSetPathResult($pathResult))) {
            throw new \InvalidArgumentException($pathResultArrayErrorMessage, __LINE__);
        }
        if (is_null($pathResult) || (is_array($pathResult) && empty($pathResult))) {
            unset($this->PathResult);
        } else {
            $this->PathResult = $pathResult;
        }
        return $this;
    }
    /**
     * Add item to PathResult value
     * @throws \InvalidArgumentException
     * @param \StructType\PathResult $item
     * @return \ArrayType\ArrayOfPathResult
     */
    public function addToPathResult(\StructType\PathResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PathResult) {
            throw new \InvalidArgumentException(sprintf('The PathResult property can only contain items of type \StructType\PathResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PathResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PathResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PathResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PathResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PathResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PathResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PathResult
     */
    public function getAttributeName()
    {
        return 'PathResult';
    }
}
