<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPath ArrayType
 * @subpackage Arrays
 */
class ArrayOfPath extends AbstractStructArrayBase
{
    /**
     * The Path
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Path[]
     */
    public $Path;
    /**
     * Constructor method for ArrayOfPath
     * @uses ArrayOfPath::setPath()
     * @param \StructType\Path[] $path
     */
    public function __construct(array $path = array())
    {
        $this
            ->setPath($path);
    }
    /**
     * Get Path value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Path[]|null
     */
    public function getPath()
    {
        return isset($this->Path) ? $this->Path : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPath method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPath method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePathForArrayConstraintsFromSetPath(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPathPathItem) {
            // validation for constraint: itemType
            if (!$arrayOfPathPathItem instanceof \StructType\Path) {
                $invalidValues[] = is_object($arrayOfPathPathItem) ? get_class($arrayOfPathPathItem) : sprintf('%s(%s)', gettype($arrayOfPathPathItem), var_export($arrayOfPathPathItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Path property can only contain items of type \StructType\Path, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Path value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Path[] $path
     * @return \ArrayType\ArrayOfPath
     */
    public function setPath(array $path = array())
    {
        // validation for constraint: array
        if ('' !== ($pathArrayErrorMessage = self::validatePathForArrayConstraintsFromSetPath($path))) {
            throw new \InvalidArgumentException($pathArrayErrorMessage, __LINE__);
        }
        if (is_null($path) || (is_array($path) && empty($path))) {
            unset($this->Path);
        } else {
            $this->Path = $path;
        }
        return $this;
    }
    /**
     * Add item to Path value
     * @throws \InvalidArgumentException
     * @param \StructType\Path $item
     * @return \ArrayType\ArrayOfPath
     */
    public function addToPath(\StructType\Path $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Path) {
            throw new \InvalidArgumentException(sprintf('The Path property can only contain items of type \StructType\Path, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Path[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Path|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Path|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Path|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Path|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Path|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Path
     */
    public function getAttributeName()
    {
        return 'Path';
    }
}
