<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMapRoute ArrayType
 * @subpackage Arrays
 */
class ArrayOfMapRoute extends AbstractStructArrayBase
{
    /**
     * The MapRoute
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MapRoute[]
     */
    public $MapRoute;
    /**
     * Constructor method for ArrayOfMapRoute
     * @uses ArrayOfMapRoute::setMapRoute()
     * @param \StructType\MapRoute[] $mapRoute
     */
    public function __construct(array $mapRoute = array())
    {
        $this
            ->setMapRoute($mapRoute);
    }
    /**
     * Get MapRoute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MapRoute[]|null
     */
    public function getMapRoute()
    {
        return isset($this->MapRoute) ? $this->MapRoute : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMapRoute method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMapRoute method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMapRouteForArrayConstraintsFromSetMapRoute(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMapRouteMapRouteItem) {
            // validation for constraint: itemType
            if (!$arrayOfMapRouteMapRouteItem instanceof \StructType\MapRoute) {
                $invalidValues[] = is_object($arrayOfMapRouteMapRouteItem) ? get_class($arrayOfMapRouteMapRouteItem) : sprintf('%s(%s)', gettype($arrayOfMapRouteMapRouteItem), var_export($arrayOfMapRouteMapRouteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MapRoute property can only contain items of type \StructType\MapRoute, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MapRoute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MapRoute[] $mapRoute
     * @return \ArrayType\ArrayOfMapRoute
     */
    public function setMapRoute(array $mapRoute = array())
    {
        // validation for constraint: array
        if ('' !== ($mapRouteArrayErrorMessage = self::validateMapRouteForArrayConstraintsFromSetMapRoute($mapRoute))) {
            throw new \InvalidArgumentException($mapRouteArrayErrorMessage, __LINE__);
        }
        if (is_null($mapRoute) || (is_array($mapRoute) && empty($mapRoute))) {
            unset($this->MapRoute);
        } else {
            $this->MapRoute = $mapRoute;
        }
        return $this;
    }
    /**
     * Add item to MapRoute value
     * @throws \InvalidArgumentException
     * @param \StructType\MapRoute $item
     * @return \ArrayType\ArrayOfMapRoute
     */
    public function addToMapRoute(\StructType\MapRoute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MapRoute) {
            throw new \InvalidArgumentException(sprintf('The MapRoute property can only contain items of type \StructType\MapRoute, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MapRoute[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MapRoute|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MapRoute|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MapRoute|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MapRoute|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MapRoute|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MapRoute
     */
    public function getAttributeName()
    {
        return 'MapRoute';
    }
}
