<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMapItem_V3 ArrayType
 * @subpackage Arrays
 */
class ArrayOfMapItem_V3 extends AbstractStructArrayBase
{
    /**
     * The MapItem_V3
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MapItem_V3[]
     */
    public $MapItem_V3;
    /**
     * Constructor method for ArrayOfMapItem_V3
     * @uses ArrayOfMapItem_V3::setMapItem_V3()
     * @param \StructType\MapItem_V3[] $mapItem_V3
     */
    public function __construct(array $mapItem_V3 = array())
    {
        $this
            ->setMapItem_V3($mapItem_V3);
    }
    /**
     * Get MapItem_V3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MapItem_V3[]|null
     */
    public function getMapItem_V3()
    {
        return isset($this->MapItem_V3) ? $this->MapItem_V3 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMapItem_V3 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMapItem_V3 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMapItem_V3ForArrayConstraintsFromSetMapItem_V3(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMapItem_V3MapItem_V3Item) {
            // validation for constraint: itemType
            if (!$arrayOfMapItem_V3MapItem_V3Item instanceof \StructType\MapItem_V3) {
                $invalidValues[] = is_object($arrayOfMapItem_V3MapItem_V3Item) ? get_class($arrayOfMapItem_V3MapItem_V3Item) : sprintf('%s(%s)', gettype($arrayOfMapItem_V3MapItem_V3Item), var_export($arrayOfMapItem_V3MapItem_V3Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MapItem_V3 property can only contain items of type \StructType\MapItem_V3, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MapItem_V3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MapItem_V3[] $mapItem_V3
     * @return \ArrayType\ArrayOfMapItem_V3
     */
    public function setMapItem_V3(array $mapItem_V3 = array())
    {
        // validation for constraint: array
        if ('' !== ($mapItem_V3ArrayErrorMessage = self::validateMapItem_V3ForArrayConstraintsFromSetMapItem_V3($mapItem_V3))) {
            throw new \InvalidArgumentException($mapItem_V3ArrayErrorMessage, __LINE__);
        }
        if (is_null($mapItem_V3) || (is_array($mapItem_V3) && empty($mapItem_V3))) {
            unset($this->MapItem_V3);
        } else {
            $this->MapItem_V3 = $mapItem_V3;
        }
        return $this;
    }
    /**
     * Add item to MapItem_V3 value
     * @throws \InvalidArgumentException
     * @param \StructType\MapItem_V3 $item
     * @return \ArrayType\ArrayOfMapItem_V3
     */
    public function addToMapItem_V3(\StructType\MapItem_V3 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MapItem_V3) {
            throw new \InvalidArgumentException(sprintf('The MapItem_V3 property can only contain items of type \StructType\MapItem_V3, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MapItem_V3[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MapItem_V3|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MapItem_V3|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MapItem_V3|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MapItem_V3|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MapItem_V3|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MapItem_V3
     */
    public function getAttributeName()
    {
        return 'MapItem_V3';
    }
}
