<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJobItemResult_V4 ArrayType
 * @subpackage Arrays
 */
class ArrayOfJobItemResult_V4 extends AbstractStructArrayBase
{
    /**
     * The JobItemResult_V4
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\JobItemResult_V4[]
     */
    public $JobItemResult_V4;
    /**
     * Constructor method for ArrayOfJobItemResult_V4
     * @uses ArrayOfJobItemResult_V4::setJobItemResult_V4()
     * @param \StructType\JobItemResult_V4[] $jobItemResult_V4
     */
    public function __construct(array $jobItemResult_V4 = array())
    {
        $this
            ->setJobItemResult_V4($jobItemResult_V4);
    }
    /**
     * Get JobItemResult_V4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\JobItemResult_V4[]|null
     */
    public function getJobItemResult_V4()
    {
        return isset($this->JobItemResult_V4) ? $this->JobItemResult_V4 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setJobItemResult_V4 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJobItemResult_V4 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJobItemResult_V4ForArrayConstraintsFromSetJobItemResult_V4(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJobItemResult_V4JobItemResult_V4Item) {
            // validation for constraint: itemType
            if (!$arrayOfJobItemResult_V4JobItemResult_V4Item instanceof \StructType\JobItemResult_V4) {
                $invalidValues[] = is_object($arrayOfJobItemResult_V4JobItemResult_V4Item) ? get_class($arrayOfJobItemResult_V4JobItemResult_V4Item) : sprintf('%s(%s)', gettype($arrayOfJobItemResult_V4JobItemResult_V4Item), var_export($arrayOfJobItemResult_V4JobItemResult_V4Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The JobItemResult_V4 property can only contain items of type \StructType\JobItemResult_V4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set JobItemResult_V4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\JobItemResult_V4[] $jobItemResult_V4
     * @return \ArrayType\ArrayOfJobItemResult_V4
     */
    public function setJobItemResult_V4(array $jobItemResult_V4 = array())
    {
        // validation for constraint: array
        if ('' !== ($jobItemResult_V4ArrayErrorMessage = self::validateJobItemResult_V4ForArrayConstraintsFromSetJobItemResult_V4($jobItemResult_V4))) {
            throw new \InvalidArgumentException($jobItemResult_V4ArrayErrorMessage, __LINE__);
        }
        if (is_null($jobItemResult_V4) || (is_array($jobItemResult_V4) && empty($jobItemResult_V4))) {
            unset($this->JobItemResult_V4);
        } else {
            $this->JobItemResult_V4 = $jobItemResult_V4;
        }
        return $this;
    }
    /**
     * Add item to JobItemResult_V4 value
     * @throws \InvalidArgumentException
     * @param \StructType\JobItemResult_V4 $item
     * @return \ArrayType\ArrayOfJobItemResult_V4
     */
    public function addToJobItemResult_V4(\StructType\JobItemResult_V4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JobItemResult_V4) {
            throw new \InvalidArgumentException(sprintf('The JobItemResult_V4 property can only contain items of type \StructType\JobItemResult_V4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->JobItemResult_V4[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JobItemResult_V4|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JobItemResult_V4|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JobItemResult_V4|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JobItemResult_V4|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JobItemResult_V4|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string JobItemResult_V4
     */
    public function getAttributeName()
    {
        return 'JobItemResult_V4';
    }
}
