<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJobItemResult_V3 ArrayType
 * @subpackage Arrays
 */
class ArrayOfJobItemResult_V3 extends AbstractStructArrayBase
{
    /**
     * The JobItemResult_V3
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\JobItemResult_V3[]
     */
    public $JobItemResult_V3;
    /**
     * Constructor method for ArrayOfJobItemResult_V3
     * @uses ArrayOfJobItemResult_V3::setJobItemResult_V3()
     * @param \StructType\JobItemResult_V3[] $jobItemResult_V3
     */
    public function __construct(array $jobItemResult_V3 = array())
    {
        $this
            ->setJobItemResult_V3($jobItemResult_V3);
    }
    /**
     * Get JobItemResult_V3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\JobItemResult_V3[]|null
     */
    public function getJobItemResult_V3()
    {
        return isset($this->JobItemResult_V3) ? $this->JobItemResult_V3 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setJobItemResult_V3 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJobItemResult_V3 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJobItemResult_V3ForArrayConstraintsFromSetJobItemResult_V3(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJobItemResult_V3JobItemResult_V3Item) {
            // validation for constraint: itemType
            if (!$arrayOfJobItemResult_V3JobItemResult_V3Item instanceof \StructType\JobItemResult_V3) {
                $invalidValues[] = is_object($arrayOfJobItemResult_V3JobItemResult_V3Item) ? get_class($arrayOfJobItemResult_V3JobItemResult_V3Item) : sprintf('%s(%s)', gettype($arrayOfJobItemResult_V3JobItemResult_V3Item), var_export($arrayOfJobItemResult_V3JobItemResult_V3Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The JobItemResult_V3 property can only contain items of type \StructType\JobItemResult_V3, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set JobItemResult_V3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\JobItemResult_V3[] $jobItemResult_V3
     * @return \ArrayType\ArrayOfJobItemResult_V3
     */
    public function setJobItemResult_V3(array $jobItemResult_V3 = array())
    {
        // validation for constraint: array
        if ('' !== ($jobItemResult_V3ArrayErrorMessage = self::validateJobItemResult_V3ForArrayConstraintsFromSetJobItemResult_V3($jobItemResult_V3))) {
            throw new \InvalidArgumentException($jobItemResult_V3ArrayErrorMessage, __LINE__);
        }
        if (is_null($jobItemResult_V3) || (is_array($jobItemResult_V3) && empty($jobItemResult_V3))) {
            unset($this->JobItemResult_V3);
        } else {
            $this->JobItemResult_V3 = $jobItemResult_V3;
        }
        return $this;
    }
    /**
     * Add item to JobItemResult_V3 value
     * @throws \InvalidArgumentException
     * @param \StructType\JobItemResult_V3 $item
     * @return \ArrayType\ArrayOfJobItemResult_V3
     */
    public function addToJobItemResult_V3(\StructType\JobItemResult_V3 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JobItemResult_V3) {
            throw new \InvalidArgumentException(sprintf('The JobItemResult_V3 property can only contain items of type \StructType\JobItemResult_V3, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->JobItemResult_V3[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JobItemResult_V3|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JobItemResult_V3|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JobItemResult_V3|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JobItemResult_V3|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JobItemResult_V3|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string JobItemResult_V3
     */
    public function getAttributeName()
    {
        return 'JobItemResult_V3';
    }
}
