<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInspectionItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfInspectionItem extends AbstractStructArrayBase
{
    /**
     * The InspectionItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InspectionItem[]
     */
    public $InspectionItem;
    /**
     * Constructor method for ArrayOfInspectionItem
     * @uses ArrayOfInspectionItem::setInspectionItem()
     * @param \StructType\InspectionItem[] $inspectionItem
     */
    public function __construct(array $inspectionItem = array())
    {
        $this
            ->setInspectionItem($inspectionItem);
    }
    /**
     * Get InspectionItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InspectionItem[]|null
     */
    public function getInspectionItem()
    {
        return isset($this->InspectionItem) ? $this->InspectionItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInspectionItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInspectionItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInspectionItemForArrayConstraintsFromSetInspectionItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfInspectionItemInspectionItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfInspectionItemInspectionItemItem instanceof \StructType\InspectionItem) {
                $invalidValues[] = is_object($arrayOfInspectionItemInspectionItemItem) ? get_class($arrayOfInspectionItemInspectionItemItem) : sprintf('%s(%s)', gettype($arrayOfInspectionItemInspectionItemItem), var_export($arrayOfInspectionItemInspectionItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InspectionItem property can only contain items of type \StructType\InspectionItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InspectionItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InspectionItem[] $inspectionItem
     * @return \ArrayType\ArrayOfInspectionItem
     */
    public function setInspectionItem(array $inspectionItem = array())
    {
        // validation for constraint: array
        if ('' !== ($inspectionItemArrayErrorMessage = self::validateInspectionItemForArrayConstraintsFromSetInspectionItem($inspectionItem))) {
            throw new \InvalidArgumentException($inspectionItemArrayErrorMessage, __LINE__);
        }
        if (is_null($inspectionItem) || (is_array($inspectionItem) && empty($inspectionItem))) {
            unset($this->InspectionItem);
        } else {
            $this->InspectionItem = $inspectionItem;
        }
        return $this;
    }
    /**
     * Add item to InspectionItem value
     * @throws \InvalidArgumentException
     * @param \StructType\InspectionItem $item
     * @return \ArrayType\ArrayOfInspectionItem
     */
    public function addToInspectionItem(\StructType\InspectionItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InspectionItem) {
            throw new \InvalidArgumentException(sprintf('The InspectionItem property can only contain items of type \StructType\InspectionItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InspectionItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\InspectionItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\InspectionItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\InspectionItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\InspectionItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\InspectionItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InspectionItem
     */
    public function getAttributeName()
    {
        return 'InspectionItem';
    }
}
