<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfIdentifierUser ArrayType
 * @subpackage Arrays
 */
class ArrayOfIdentifierUser extends AbstractStructArrayBase
{
    /**
     * The IdentifierUser
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IdentifierUser[]
     */
    public $IdentifierUser;
    /**
     * Constructor method for ArrayOfIdentifierUser
     * @uses ArrayOfIdentifierUser::setIdentifierUser()
     * @param \StructType\IdentifierUser[] $identifierUser
     */
    public function __construct(array $identifierUser = array())
    {
        $this
            ->setIdentifierUser($identifierUser);
    }
    /**
     * Get IdentifierUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IdentifierUser[]|null
     */
    public function getIdentifierUser()
    {
        return isset($this->IdentifierUser) ? $this->IdentifierUser : null;
    }
    /**
     * This method is responsible for validating the values passed to the setIdentifierUser method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdentifierUser method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdentifierUserForArrayConstraintsFromSetIdentifierUser(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfIdentifierUserIdentifierUserItem) {
            // validation for constraint: itemType
            if (!$arrayOfIdentifierUserIdentifierUserItem instanceof \StructType\IdentifierUser) {
                $invalidValues[] = is_object($arrayOfIdentifierUserIdentifierUserItem) ? get_class($arrayOfIdentifierUserIdentifierUserItem) : sprintf('%s(%s)', gettype($arrayOfIdentifierUserIdentifierUserItem), var_export($arrayOfIdentifierUserIdentifierUserItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The IdentifierUser property can only contain items of type \StructType\IdentifierUser, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set IdentifierUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifierUser[] $identifierUser
     * @return \ArrayType\ArrayOfIdentifierUser
     */
    public function setIdentifierUser(array $identifierUser = array())
    {
        // validation for constraint: array
        if ('' !== ($identifierUserArrayErrorMessage = self::validateIdentifierUserForArrayConstraintsFromSetIdentifierUser($identifierUser))) {
            throw new \InvalidArgumentException($identifierUserArrayErrorMessage, __LINE__);
        }
        if (is_null($identifierUser) || (is_array($identifierUser) && empty($identifierUser))) {
            unset($this->IdentifierUser);
        } else {
            $this->IdentifierUser = $identifierUser;
        }
        return $this;
    }
    /**
     * Add item to IdentifierUser value
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifierUser $item
     * @return \ArrayType\ArrayOfIdentifierUser
     */
    public function addToIdentifierUser(\StructType\IdentifierUser $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IdentifierUser) {
            throw new \InvalidArgumentException(sprintf('The IdentifierUser property can only contain items of type \StructType\IdentifierUser, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->IdentifierUser[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\IdentifierUser|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\IdentifierUser|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\IdentifierUser|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\IdentifierUser|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\IdentifierUser|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string IdentifierUser
     */
    public function getAttributeName()
    {
        return 'IdentifierUser';
    }
}
