<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfIdentifierResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfIdentifierResult extends AbstractStructArrayBase
{
    /**
     * The IdentifierResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IdentifierResult[]
     */
    public $IdentifierResult;
    /**
     * Constructor method for ArrayOfIdentifierResult
     * @uses ArrayOfIdentifierResult::setIdentifierResult()
     * @param \StructType\IdentifierResult[] $identifierResult
     */
    public function __construct(array $identifierResult = array())
    {
        $this
            ->setIdentifierResult($identifierResult);
    }
    /**
     * Get IdentifierResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IdentifierResult[]|null
     */
    public function getIdentifierResult()
    {
        return isset($this->IdentifierResult) ? $this->IdentifierResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setIdentifierResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdentifierResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdentifierResultForArrayConstraintsFromSetIdentifierResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfIdentifierResultIdentifierResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfIdentifierResultIdentifierResultItem instanceof \StructType\IdentifierResult) {
                $invalidValues[] = is_object($arrayOfIdentifierResultIdentifierResultItem) ? get_class($arrayOfIdentifierResultIdentifierResultItem) : sprintf('%s(%s)', gettype($arrayOfIdentifierResultIdentifierResultItem), var_export($arrayOfIdentifierResultIdentifierResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The IdentifierResult property can only contain items of type \StructType\IdentifierResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set IdentifierResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifierResult[] $identifierResult
     * @return \ArrayType\ArrayOfIdentifierResult
     */
    public function setIdentifierResult(array $identifierResult = array())
    {
        // validation for constraint: array
        if ('' !== ($identifierResultArrayErrorMessage = self::validateIdentifierResultForArrayConstraintsFromSetIdentifierResult($identifierResult))) {
            throw new \InvalidArgumentException($identifierResultArrayErrorMessage, __LINE__);
        }
        if (is_null($identifierResult) || (is_array($identifierResult) && empty($identifierResult))) {
            unset($this->IdentifierResult);
        } else {
            $this->IdentifierResult = $identifierResult;
        }
        return $this;
    }
    /**
     * Add item to IdentifierResult value
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifierResult $item
     * @return \ArrayType\ArrayOfIdentifierResult
     */
    public function addToIdentifierResult(\StructType\IdentifierResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IdentifierResult) {
            throw new \InvalidArgumentException(sprintf('The IdentifierResult property can only contain items of type \StructType\IdentifierResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->IdentifierResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\IdentifierResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\IdentifierResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\IdentifierResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\IdentifierResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\IdentifierResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string IdentifierResult
     */
    public function getAttributeName()
    {
        return 'IdentifierResult';
    }
}
