<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfIdentifierFile ArrayType
 * @subpackage Arrays
 */
class ArrayOfIdentifierFile extends AbstractStructArrayBase
{
    /**
     * The IdentifierFile
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IdentifierFile[]
     */
    public $IdentifierFile;
    /**
     * Constructor method for ArrayOfIdentifierFile
     * @uses ArrayOfIdentifierFile::setIdentifierFile()
     * @param \StructType\IdentifierFile[] $identifierFile
     */
    public function __construct(array $identifierFile = array())
    {
        $this
            ->setIdentifierFile($identifierFile);
    }
    /**
     * Get IdentifierFile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IdentifierFile[]|null
     */
    public function getIdentifierFile()
    {
        return isset($this->IdentifierFile) ? $this->IdentifierFile : null;
    }
    /**
     * This method is responsible for validating the values passed to the setIdentifierFile method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdentifierFile method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdentifierFileForArrayConstraintsFromSetIdentifierFile(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfIdentifierFileIdentifierFileItem) {
            // validation for constraint: itemType
            if (!$arrayOfIdentifierFileIdentifierFileItem instanceof \StructType\IdentifierFile) {
                $invalidValues[] = is_object($arrayOfIdentifierFileIdentifierFileItem) ? get_class($arrayOfIdentifierFileIdentifierFileItem) : sprintf('%s(%s)', gettype($arrayOfIdentifierFileIdentifierFileItem), var_export($arrayOfIdentifierFileIdentifierFileItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The IdentifierFile property can only contain items of type \StructType\IdentifierFile, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set IdentifierFile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifierFile[] $identifierFile
     * @return \ArrayType\ArrayOfIdentifierFile
     */
    public function setIdentifierFile(array $identifierFile = array())
    {
        // validation for constraint: array
        if ('' !== ($identifierFileArrayErrorMessage = self::validateIdentifierFileForArrayConstraintsFromSetIdentifierFile($identifierFile))) {
            throw new \InvalidArgumentException($identifierFileArrayErrorMessage, __LINE__);
        }
        if (is_null($identifierFile) || (is_array($identifierFile) && empty($identifierFile))) {
            unset($this->IdentifierFile);
        } else {
            $this->IdentifierFile = $identifierFile;
        }
        return $this;
    }
    /**
     * Add item to IdentifierFile value
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifierFile $item
     * @return \ArrayType\ArrayOfIdentifierFile
     */
    public function addToIdentifierFile(\StructType\IdentifierFile $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IdentifierFile) {
            throw new \InvalidArgumentException(sprintf('The IdentifierFile property can only contain items of type \StructType\IdentifierFile, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->IdentifierFile[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\IdentifierFile|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\IdentifierFile|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\IdentifierFile|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\IdentifierFile|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\IdentifierFile|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string IdentifierFile
     */
    public function getAttributeName()
    {
        return 'IdentifierFile';
    }
}
