<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGroupResultV2 ArrayType
 * @subpackage Arrays
 */
class ArrayOfGroupResultV2 extends AbstractStructArrayBase
{
    /**
     * The GroupResultV2
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GroupResultV2[]
     */
    public $GroupResultV2;
    /**
     * Constructor method for ArrayOfGroupResultV2
     * @uses ArrayOfGroupResultV2::setGroupResultV2()
     * @param \StructType\GroupResultV2[] $groupResultV2
     */
    public function __construct(array $groupResultV2 = array())
    {
        $this
            ->setGroupResultV2($groupResultV2);
    }
    /**
     * Get GroupResultV2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GroupResultV2[]|null
     */
    public function getGroupResultV2()
    {
        return isset($this->GroupResultV2) ? $this->GroupResultV2 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setGroupResultV2 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGroupResultV2 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGroupResultV2ForArrayConstraintsFromSetGroupResultV2(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfGroupResultV2GroupResultV2Item) {
            // validation for constraint: itemType
            if (!$arrayOfGroupResultV2GroupResultV2Item instanceof \StructType\GroupResultV2) {
                $invalidValues[] = is_object($arrayOfGroupResultV2GroupResultV2Item) ? get_class($arrayOfGroupResultV2GroupResultV2Item) : sprintf('%s(%s)', gettype($arrayOfGroupResultV2GroupResultV2Item), var_export($arrayOfGroupResultV2GroupResultV2Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GroupResultV2 property can only contain items of type \StructType\GroupResultV2, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GroupResultV2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GroupResultV2[] $groupResultV2
     * @return \ArrayType\ArrayOfGroupResultV2
     */
    public function setGroupResultV2(array $groupResultV2 = array())
    {
        // validation for constraint: array
        if ('' !== ($groupResultV2ArrayErrorMessage = self::validateGroupResultV2ForArrayConstraintsFromSetGroupResultV2($groupResultV2))) {
            throw new \InvalidArgumentException($groupResultV2ArrayErrorMessage, __LINE__);
        }
        if (is_null($groupResultV2) || (is_array($groupResultV2) && empty($groupResultV2))) {
            unset($this->GroupResultV2);
        } else {
            $this->GroupResultV2 = $groupResultV2;
        }
        return $this;
    }
    /**
     * Add item to GroupResultV2 value
     * @throws \InvalidArgumentException
     * @param \StructType\GroupResultV2 $item
     * @return \ArrayType\ArrayOfGroupResultV2
     */
    public function addToGroupResultV2(\StructType\GroupResultV2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GroupResultV2) {
            throw new \InvalidArgumentException(sprintf('The GroupResultV2 property can only contain items of type \StructType\GroupResultV2, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GroupResultV2[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\GroupResultV2|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\GroupResultV2|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\GroupResultV2|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\GroupResultV2|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\GroupResultV2|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string GroupResultV2
     */
    public function getAttributeName()
    {
        return 'GroupResultV2';
    }
}
