<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGroupIdentifier ArrayType
 * @subpackage Arrays
 */
class ArrayOfGroupIdentifier extends AbstractStructArrayBase
{
    /**
     * The GroupIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GroupIdentifier[]
     */
    public $GroupIdentifier;
    /**
     * Constructor method for ArrayOfGroupIdentifier
     * @uses ArrayOfGroupIdentifier::setGroupIdentifier()
     * @param \StructType\GroupIdentifier[] $groupIdentifier
     */
    public function __construct(array $groupIdentifier = array())
    {
        $this
            ->setGroupIdentifier($groupIdentifier);
    }
    /**
     * Get GroupIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GroupIdentifier[]|null
     */
    public function getGroupIdentifier()
    {
        return isset($this->GroupIdentifier) ? $this->GroupIdentifier : null;
    }
    /**
     * This method is responsible for validating the values passed to the setGroupIdentifier method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGroupIdentifier method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGroupIdentifierForArrayConstraintsFromSetGroupIdentifier(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfGroupIdentifierGroupIdentifierItem) {
            // validation for constraint: itemType
            if (!$arrayOfGroupIdentifierGroupIdentifierItem instanceof \StructType\GroupIdentifier) {
                $invalidValues[] = is_object($arrayOfGroupIdentifierGroupIdentifierItem) ? get_class($arrayOfGroupIdentifierGroupIdentifierItem) : sprintf('%s(%s)', gettype($arrayOfGroupIdentifierGroupIdentifierItem), var_export($arrayOfGroupIdentifierGroupIdentifierItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GroupIdentifier property can only contain items of type \StructType\GroupIdentifier, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GroupIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GroupIdentifier[] $groupIdentifier
     * @return \ArrayType\ArrayOfGroupIdentifier
     */
    public function setGroupIdentifier(array $groupIdentifier = array())
    {
        // validation for constraint: array
        if ('' !== ($groupIdentifierArrayErrorMessage = self::validateGroupIdentifierForArrayConstraintsFromSetGroupIdentifier($groupIdentifier))) {
            throw new \InvalidArgumentException($groupIdentifierArrayErrorMessage, __LINE__);
        }
        if (is_null($groupIdentifier) || (is_array($groupIdentifier) && empty($groupIdentifier))) {
            unset($this->GroupIdentifier);
        } else {
            $this->GroupIdentifier = $groupIdentifier;
        }
        return $this;
    }
    /**
     * Add item to GroupIdentifier value
     * @throws \InvalidArgumentException
     * @param \StructType\GroupIdentifier $item
     * @return \ArrayType\ArrayOfGroupIdentifier
     */
    public function addToGroupIdentifier(\StructType\GroupIdentifier $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GroupIdentifier) {
            throw new \InvalidArgumentException(sprintf('The GroupIdentifier property can only contain items of type \StructType\GroupIdentifier, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GroupIdentifier[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\GroupIdentifier|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\GroupIdentifier|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\GroupIdentifier|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\GroupIdentifier|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\GroupIdentifier|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string GroupIdentifier
     */
    public function getAttributeName()
    {
        return 'GroupIdentifier';
    }
}
