<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGeofenceResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfGeofenceResult extends AbstractStructArrayBase
{
    /**
     * The GeofenceResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GeofenceResult[]
     */
    public $GeofenceResult;
    /**
     * Constructor method for ArrayOfGeofenceResult
     * @uses ArrayOfGeofenceResult::setGeofenceResult()
     * @param \StructType\GeofenceResult[] $geofenceResult
     */
    public function __construct(array $geofenceResult = array())
    {
        $this
            ->setGeofenceResult($geofenceResult);
    }
    /**
     * Get GeofenceResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GeofenceResult[]|null
     */
    public function getGeofenceResult()
    {
        return isset($this->GeofenceResult) ? $this->GeofenceResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setGeofenceResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGeofenceResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGeofenceResultForArrayConstraintsFromSetGeofenceResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfGeofenceResultGeofenceResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfGeofenceResultGeofenceResultItem instanceof \StructType\GeofenceResult) {
                $invalidValues[] = is_object($arrayOfGeofenceResultGeofenceResultItem) ? get_class($arrayOfGeofenceResultGeofenceResultItem) : sprintf('%s(%s)', gettype($arrayOfGeofenceResultGeofenceResultItem), var_export($arrayOfGeofenceResultGeofenceResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GeofenceResult property can only contain items of type \StructType\GeofenceResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GeofenceResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GeofenceResult[] $geofenceResult
     * @return \ArrayType\ArrayOfGeofenceResult
     */
    public function setGeofenceResult(array $geofenceResult = array())
    {
        // validation for constraint: array
        if ('' !== ($geofenceResultArrayErrorMessage = self::validateGeofenceResultForArrayConstraintsFromSetGeofenceResult($geofenceResult))) {
            throw new \InvalidArgumentException($geofenceResultArrayErrorMessage, __LINE__);
        }
        if (is_null($geofenceResult) || (is_array($geofenceResult) && empty($geofenceResult))) {
            unset($this->GeofenceResult);
        } else {
            $this->GeofenceResult = $geofenceResult;
        }
        return $this;
    }
    /**
     * Add item to GeofenceResult value
     * @throws \InvalidArgumentException
     * @param \StructType\GeofenceResult $item
     * @return \ArrayType\ArrayOfGeofenceResult
     */
    public function addToGeofenceResult(\StructType\GeofenceResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GeofenceResult) {
            throw new \InvalidArgumentException(sprintf('The GeofenceResult property can only contain items of type \StructType\GeofenceResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GeofenceResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\GeofenceResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\GeofenceResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\GeofenceResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\GeofenceResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\GeofenceResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string GeofenceResult
     */
    public function getAttributeName()
    {
        return 'GeofenceResult';
    }
}
