<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGenericItem_V1 ArrayType
 * @subpackage Arrays
 */
class ArrayOfGenericItem_V1 extends AbstractStructArrayBase
{
    /**
     * The GenericItem_V1
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GenericItem_V1[]
     */
    public $GenericItem_V1;
    /**
     * Constructor method for ArrayOfGenericItem_V1
     * @uses ArrayOfGenericItem_V1::setGenericItem_V1()
     * @param \StructType\GenericItem_V1[] $genericItem_V1
     */
    public function __construct(array $genericItem_V1 = array())
    {
        $this
            ->setGenericItem_V1($genericItem_V1);
    }
    /**
     * Get GenericItem_V1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GenericItem_V1[]|null
     */
    public function getGenericItem_V1()
    {
        return isset($this->GenericItem_V1) ? $this->GenericItem_V1 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setGenericItem_V1 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGenericItem_V1 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGenericItem_V1ForArrayConstraintsFromSetGenericItem_V1(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfGenericItem_V1GenericItem_V1Item) {
            // validation for constraint: itemType
            if (!$arrayOfGenericItem_V1GenericItem_V1Item instanceof \StructType\GenericItem_V1) {
                $invalidValues[] = is_object($arrayOfGenericItem_V1GenericItem_V1Item) ? get_class($arrayOfGenericItem_V1GenericItem_V1Item) : sprintf('%s(%s)', gettype($arrayOfGenericItem_V1GenericItem_V1Item), var_export($arrayOfGenericItem_V1GenericItem_V1Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GenericItem_V1 property can only contain items of type \StructType\GenericItem_V1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GenericItem_V1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GenericItem_V1[] $genericItem_V1
     * @return \ArrayType\ArrayOfGenericItem_V1
     */
    public function setGenericItem_V1(array $genericItem_V1 = array())
    {
        // validation for constraint: array
        if ('' !== ($genericItem_V1ArrayErrorMessage = self::validateGenericItem_V1ForArrayConstraintsFromSetGenericItem_V1($genericItem_V1))) {
            throw new \InvalidArgumentException($genericItem_V1ArrayErrorMessage, __LINE__);
        }
        if (is_null($genericItem_V1) || (is_array($genericItem_V1) && empty($genericItem_V1))) {
            unset($this->GenericItem_V1);
        } else {
            $this->GenericItem_V1 = $genericItem_V1;
        }
        return $this;
    }
    /**
     * Add item to GenericItem_V1 value
     * @throws \InvalidArgumentException
     * @param \StructType\GenericItem_V1 $item
     * @return \ArrayType\ArrayOfGenericItem_V1
     */
    public function addToGenericItem_V1(\StructType\GenericItem_V1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GenericItem_V1) {
            throw new \InvalidArgumentException(sprintf('The GenericItem_V1 property can only contain items of type \StructType\GenericItem_V1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GenericItem_V1[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\GenericItem_V1|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\GenericItem_V1|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\GenericItem_V1|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\GenericItem_V1|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\GenericItem_V1|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string GenericItem_V1
     */
    public function getAttributeName()
    {
        return 'GenericItem_V1';
    }
}
