<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGenericItemActual ArrayType
 * @subpackage Arrays
 */
class ArrayOfGenericItemActual extends AbstractStructArrayBase
{
    /**
     * The GenericItemActual
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GenericItemActual[]
     */
    public $GenericItemActual;
    /**
     * Constructor method for ArrayOfGenericItemActual
     * @uses ArrayOfGenericItemActual::setGenericItemActual()
     * @param \StructType\GenericItemActual[] $genericItemActual
     */
    public function __construct(array $genericItemActual = array())
    {
        $this
            ->setGenericItemActual($genericItemActual);
    }
    /**
     * Get GenericItemActual value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GenericItemActual[]|null
     */
    public function getGenericItemActual()
    {
        return isset($this->GenericItemActual) ? $this->GenericItemActual : null;
    }
    /**
     * This method is responsible for validating the values passed to the setGenericItemActual method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGenericItemActual method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGenericItemActualForArrayConstraintsFromSetGenericItemActual(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfGenericItemActualGenericItemActualItem) {
            // validation for constraint: itemType
            if (!$arrayOfGenericItemActualGenericItemActualItem instanceof \StructType\GenericItemActual) {
                $invalidValues[] = is_object($arrayOfGenericItemActualGenericItemActualItem) ? get_class($arrayOfGenericItemActualGenericItemActualItem) : sprintf('%s(%s)', gettype($arrayOfGenericItemActualGenericItemActualItem), var_export($arrayOfGenericItemActualGenericItemActualItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GenericItemActual property can only contain items of type \StructType\GenericItemActual, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GenericItemActual value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GenericItemActual[] $genericItemActual
     * @return \ArrayType\ArrayOfGenericItemActual
     */
    public function setGenericItemActual(array $genericItemActual = array())
    {
        // validation for constraint: array
        if ('' !== ($genericItemActualArrayErrorMessage = self::validateGenericItemActualForArrayConstraintsFromSetGenericItemActual($genericItemActual))) {
            throw new \InvalidArgumentException($genericItemActualArrayErrorMessage, __LINE__);
        }
        if (is_null($genericItemActual) || (is_array($genericItemActual) && empty($genericItemActual))) {
            unset($this->GenericItemActual);
        } else {
            $this->GenericItemActual = $genericItemActual;
        }
        return $this;
    }
    /**
     * Add item to GenericItemActual value
     * @throws \InvalidArgumentException
     * @param \StructType\GenericItemActual $item
     * @return \ArrayType\ArrayOfGenericItemActual
     */
    public function addToGenericItemActual(\StructType\GenericItemActual $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GenericItemActual) {
            throw new \InvalidArgumentException(sprintf('The GenericItemActual property can only contain items of type \StructType\GenericItemActual, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GenericItemActual[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\GenericItemActual|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\GenericItemActual|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\GenericItemActual|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\GenericItemActual|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\GenericItemActual|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string GenericItemActual
     */
    public function getAttributeName()
    {
        return 'GenericItemActual';
    }
}
