<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGenericItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfGenericItem extends AbstractStructArrayBase
{
    /**
     * The GenericItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GenericItem[]
     */
    public $GenericItem;
    /**
     * Constructor method for ArrayOfGenericItem
     * @uses ArrayOfGenericItem::setGenericItem()
     * @param \StructType\GenericItem[] $genericItem
     */
    public function __construct(array $genericItem = array())
    {
        $this
            ->setGenericItem($genericItem);
    }
    /**
     * Get GenericItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GenericItem[]|null
     */
    public function getGenericItem()
    {
        return isset($this->GenericItem) ? $this->GenericItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setGenericItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGenericItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGenericItemForArrayConstraintsFromSetGenericItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfGenericItemGenericItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfGenericItemGenericItemItem instanceof \StructType\GenericItem) {
                $invalidValues[] = is_object($arrayOfGenericItemGenericItemItem) ? get_class($arrayOfGenericItemGenericItemItem) : sprintf('%s(%s)', gettype($arrayOfGenericItemGenericItemItem), var_export($arrayOfGenericItemGenericItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GenericItem property can only contain items of type \StructType\GenericItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GenericItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GenericItem[] $genericItem
     * @return \ArrayType\ArrayOfGenericItem
     */
    public function setGenericItem(array $genericItem = array())
    {
        // validation for constraint: array
        if ('' !== ($genericItemArrayErrorMessage = self::validateGenericItemForArrayConstraintsFromSetGenericItem($genericItem))) {
            throw new \InvalidArgumentException($genericItemArrayErrorMessage, __LINE__);
        }
        if (is_null($genericItem) || (is_array($genericItem) && empty($genericItem))) {
            unset($this->GenericItem);
        } else {
            $this->GenericItem = $genericItem;
        }
        return $this;
    }
    /**
     * Add item to GenericItem value
     * @throws \InvalidArgumentException
     * @param \StructType\GenericItem $item
     * @return \ArrayType\ArrayOfGenericItem
     */
    public function addToGenericItem(\StructType\GenericItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GenericItem) {
            throw new \InvalidArgumentException(sprintf('The GenericItem property can only contain items of type \StructType\GenericItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GenericItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\GenericItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\GenericItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\GenericItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\GenericItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\GenericItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string GenericItem
     */
    public function getAttributeName()
    {
        return 'GenericItem';
    }
}
