<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFeatureInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfFeatureInfo extends AbstractStructArrayBase
{
    /**
     * The FeatureInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FeatureInfo[]
     */
    public $FeatureInfo;
    /**
     * Constructor method for ArrayOfFeatureInfo
     * @uses ArrayOfFeatureInfo::setFeatureInfo()
     * @param \StructType\FeatureInfo[] $featureInfo
     */
    public function __construct(array $featureInfo = array())
    {
        $this
            ->setFeatureInfo($featureInfo);
    }
    /**
     * Get FeatureInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FeatureInfo[]|null
     */
    public function getFeatureInfo()
    {
        return isset($this->FeatureInfo) ? $this->FeatureInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setFeatureInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFeatureInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFeatureInfoForArrayConstraintsFromSetFeatureInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfFeatureInfoFeatureInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfFeatureInfoFeatureInfoItem instanceof \StructType\FeatureInfo) {
                $invalidValues[] = is_object($arrayOfFeatureInfoFeatureInfoItem) ? get_class($arrayOfFeatureInfoFeatureInfoItem) : sprintf('%s(%s)', gettype($arrayOfFeatureInfoFeatureInfoItem), var_export($arrayOfFeatureInfoFeatureInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FeatureInfo property can only contain items of type \StructType\FeatureInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FeatureInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FeatureInfo[] $featureInfo
     * @return \ArrayType\ArrayOfFeatureInfo
     */
    public function setFeatureInfo(array $featureInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($featureInfoArrayErrorMessage = self::validateFeatureInfoForArrayConstraintsFromSetFeatureInfo($featureInfo))) {
            throw new \InvalidArgumentException($featureInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($featureInfo) || (is_array($featureInfo) && empty($featureInfo))) {
            unset($this->FeatureInfo);
        } else {
            $this->FeatureInfo = $featureInfo;
        }
        return $this;
    }
    /**
     * Add item to FeatureInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\FeatureInfo $item
     * @return \ArrayType\ArrayOfFeatureInfo
     */
    public function addToFeatureInfo(\StructType\FeatureInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FeatureInfo) {
            throw new \InvalidArgumentException(sprintf('The FeatureInfo property can only contain items of type \StructType\FeatureInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FeatureInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\FeatureInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\FeatureInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\FeatureInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\FeatureInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\FeatureInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FeatureInfo
     */
    public function getAttributeName()
    {
        return 'FeatureInfo';
    }
}
