<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfExtraInfo_V2 ArrayType
 * @subpackage Arrays
 */
class ArrayOfExtraInfo_V2 extends AbstractStructArrayBase
{
    /**
     * The ExtraInfo_V2
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExtraInfo_V2[]
     */
    public $ExtraInfo_V2;
    /**
     * Constructor method for ArrayOfExtraInfo_V2
     * @uses ArrayOfExtraInfo_V2::setExtraInfo_V2()
     * @param \StructType\ExtraInfo_V2[] $extraInfo_V2
     */
    public function __construct(array $extraInfo_V2 = array())
    {
        $this
            ->setExtraInfo_V2($extraInfo_V2);
    }
    /**
     * Get ExtraInfo_V2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExtraInfo_V2[]|null
     */
    public function getExtraInfo_V2()
    {
        return isset($this->ExtraInfo_V2) ? $this->ExtraInfo_V2 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setExtraInfo_V2 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExtraInfo_V2 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExtraInfo_V2ForArrayConstraintsFromSetExtraInfo_V2(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfExtraInfo_V2ExtraInfo_V2Item) {
            // validation for constraint: itemType
            if (!$arrayOfExtraInfo_V2ExtraInfo_V2Item instanceof \StructType\ExtraInfo_V2) {
                $invalidValues[] = is_object($arrayOfExtraInfo_V2ExtraInfo_V2Item) ? get_class($arrayOfExtraInfo_V2ExtraInfo_V2Item) : sprintf('%s(%s)', gettype($arrayOfExtraInfo_V2ExtraInfo_V2Item), var_export($arrayOfExtraInfo_V2ExtraInfo_V2Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ExtraInfo_V2 property can only contain items of type \StructType\ExtraInfo_V2, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExtraInfo_V2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ExtraInfo_V2[] $extraInfo_V2
     * @return \ArrayType\ArrayOfExtraInfo_V2
     */
    public function setExtraInfo_V2(array $extraInfo_V2 = array())
    {
        // validation for constraint: array
        if ('' !== ($extraInfo_V2ArrayErrorMessage = self::validateExtraInfo_V2ForArrayConstraintsFromSetExtraInfo_V2($extraInfo_V2))) {
            throw new \InvalidArgumentException($extraInfo_V2ArrayErrorMessage, __LINE__);
        }
        if (is_null($extraInfo_V2) || (is_array($extraInfo_V2) && empty($extraInfo_V2))) {
            unset($this->ExtraInfo_V2);
        } else {
            $this->ExtraInfo_V2 = $extraInfo_V2;
        }
        return $this;
    }
    /**
     * Add item to ExtraInfo_V2 value
     * @throws \InvalidArgumentException
     * @param \StructType\ExtraInfo_V2 $item
     * @return \ArrayType\ArrayOfExtraInfo_V2
     */
    public function addToExtraInfo_V2(\StructType\ExtraInfo_V2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExtraInfo_V2) {
            throw new \InvalidArgumentException(sprintf('The ExtraInfo_V2 property can only contain items of type \StructType\ExtraInfo_V2, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ExtraInfo_V2[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ExtraInfo_V2|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ExtraInfo_V2|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ExtraInfo_V2|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ExtraInfo_V2|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ExtraInfo_V2|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ExtraInfo_V2
     */
    public function getAttributeName()
    {
        return 'ExtraInfo_V2';
    }
}
