<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfExtraInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfExtraInfo extends AbstractStructArrayBase
{
    /**
     * The ExtraInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExtraInfo[]
     */
    public $ExtraInfo;
    /**
     * Constructor method for ArrayOfExtraInfo
     * @uses ArrayOfExtraInfo::setExtraInfo()
     * @param \StructType\ExtraInfo[] $extraInfo
     */
    public function __construct(array $extraInfo = array())
    {
        $this
            ->setExtraInfo($extraInfo);
    }
    /**
     * Get ExtraInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExtraInfo[]|null
     */
    public function getExtraInfo()
    {
        return isset($this->ExtraInfo) ? $this->ExtraInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setExtraInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExtraInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExtraInfoForArrayConstraintsFromSetExtraInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfExtraInfoExtraInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfExtraInfoExtraInfoItem instanceof \StructType\ExtraInfo) {
                $invalidValues[] = is_object($arrayOfExtraInfoExtraInfoItem) ? get_class($arrayOfExtraInfoExtraInfoItem) : sprintf('%s(%s)', gettype($arrayOfExtraInfoExtraInfoItem), var_export($arrayOfExtraInfoExtraInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ExtraInfo property can only contain items of type \StructType\ExtraInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExtraInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ExtraInfo[] $extraInfo
     * @return \ArrayType\ArrayOfExtraInfo
     */
    public function setExtraInfo(array $extraInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($extraInfoArrayErrorMessage = self::validateExtraInfoForArrayConstraintsFromSetExtraInfo($extraInfo))) {
            throw new \InvalidArgumentException($extraInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($extraInfo) || (is_array($extraInfo) && empty($extraInfo))) {
            unset($this->ExtraInfo);
        } else {
            $this->ExtraInfo = $extraInfo;
        }
        return $this;
    }
    /**
     * Add item to ExtraInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ExtraInfo $item
     * @return \ArrayType\ArrayOfExtraInfo
     */
    public function addToExtraInfo(\StructType\ExtraInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExtraInfo) {
            throw new \InvalidArgumentException(sprintf('The ExtraInfo property can only contain items of type \StructType\ExtraInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ExtraInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ExtraInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ExtraInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ExtraInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ExtraInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ExtraInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ExtraInfo
     */
    public function getAttributeName()
    {
        return 'ExtraInfo';
    }
}
