<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEngineActivity ArrayType
 * @subpackage Arrays
 */
class ArrayOfEngineActivity extends AbstractStructArrayBase
{
    /**
     * The EngineActivity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EngineActivity[]
     */
    public $EngineActivity;
    /**
     * Constructor method for ArrayOfEngineActivity
     * @uses ArrayOfEngineActivity::setEngineActivity()
     * @param \StructType\EngineActivity[] $engineActivity
     */
    public function __construct(array $engineActivity = array())
    {
        $this
            ->setEngineActivity($engineActivity);
    }
    /**
     * Get EngineActivity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EngineActivity[]|null
     */
    public function getEngineActivity()
    {
        return isset($this->EngineActivity) ? $this->EngineActivity : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEngineActivity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEngineActivity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEngineActivityForArrayConstraintsFromSetEngineActivity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfEngineActivityEngineActivityItem) {
            // validation for constraint: itemType
            if (!$arrayOfEngineActivityEngineActivityItem instanceof \StructType\EngineActivity) {
                $invalidValues[] = is_object($arrayOfEngineActivityEngineActivityItem) ? get_class($arrayOfEngineActivityEngineActivityItem) : sprintf('%s(%s)', gettype($arrayOfEngineActivityEngineActivityItem), var_export($arrayOfEngineActivityEngineActivityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EngineActivity property can only contain items of type \StructType\EngineActivity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EngineActivity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EngineActivity[] $engineActivity
     * @return \ArrayType\ArrayOfEngineActivity
     */
    public function setEngineActivity(array $engineActivity = array())
    {
        // validation for constraint: array
        if ('' !== ($engineActivityArrayErrorMessage = self::validateEngineActivityForArrayConstraintsFromSetEngineActivity($engineActivity))) {
            throw new \InvalidArgumentException($engineActivityArrayErrorMessage, __LINE__);
        }
        if (is_null($engineActivity) || (is_array($engineActivity) && empty($engineActivity))) {
            unset($this->EngineActivity);
        } else {
            $this->EngineActivity = $engineActivity;
        }
        return $this;
    }
    /**
     * Add item to EngineActivity value
     * @throws \InvalidArgumentException
     * @param \StructType\EngineActivity $item
     * @return \ArrayType\ArrayOfEngineActivity
     */
    public function addToEngineActivity(\StructType\EngineActivity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EngineActivity) {
            throw new \InvalidArgumentException(sprintf('The EngineActivity property can only contain items of type \StructType\EngineActivity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EngineActivity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EngineActivity|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EngineActivity|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EngineActivity|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EngineActivity|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EngineActivity|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EngineActivity
     */
    public function getAttributeName()
    {
        return 'EngineActivity';
    }
}
