<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDriverSocialProfileItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfDriverSocialProfileItem extends AbstractStructArrayBase
{
    /**
     * The DriverSocialProfileItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DriverSocialProfileItem[]
     */
    public $DriverSocialProfileItem;
    /**
     * Constructor method for ArrayOfDriverSocialProfileItem
     * @uses ArrayOfDriverSocialProfileItem::setDriverSocialProfileItem()
     * @param \StructType\DriverSocialProfileItem[] $driverSocialProfileItem
     */
    public function __construct(array $driverSocialProfileItem = array())
    {
        $this
            ->setDriverSocialProfileItem($driverSocialProfileItem);
    }
    /**
     * Get DriverSocialProfileItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DriverSocialProfileItem[]|null
     */
    public function getDriverSocialProfileItem()
    {
        return isset($this->DriverSocialProfileItem) ? $this->DriverSocialProfileItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDriverSocialProfileItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDriverSocialProfileItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDriverSocialProfileItemForArrayConstraintsFromSetDriverSocialProfileItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDriverSocialProfileItemDriverSocialProfileItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfDriverSocialProfileItemDriverSocialProfileItemItem instanceof \StructType\DriverSocialProfileItem) {
                $invalidValues[] = is_object($arrayOfDriverSocialProfileItemDriverSocialProfileItemItem) ? get_class($arrayOfDriverSocialProfileItemDriverSocialProfileItemItem) : sprintf('%s(%s)', gettype($arrayOfDriverSocialProfileItemDriverSocialProfileItemItem), var_export($arrayOfDriverSocialProfileItemDriverSocialProfileItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DriverSocialProfileItem property can only contain items of type \StructType\DriverSocialProfileItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DriverSocialProfileItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DriverSocialProfileItem[] $driverSocialProfileItem
     * @return \ArrayType\ArrayOfDriverSocialProfileItem
     */
    public function setDriverSocialProfileItem(array $driverSocialProfileItem = array())
    {
        // validation for constraint: array
        if ('' !== ($driverSocialProfileItemArrayErrorMessage = self::validateDriverSocialProfileItemForArrayConstraintsFromSetDriverSocialProfileItem($driverSocialProfileItem))) {
            throw new \InvalidArgumentException($driverSocialProfileItemArrayErrorMessage, __LINE__);
        }
        if (is_null($driverSocialProfileItem) || (is_array($driverSocialProfileItem) && empty($driverSocialProfileItem))) {
            unset($this->DriverSocialProfileItem);
        } else {
            $this->DriverSocialProfileItem = $driverSocialProfileItem;
        }
        return $this;
    }
    /**
     * Add item to DriverSocialProfileItem value
     * @throws \InvalidArgumentException
     * @param \StructType\DriverSocialProfileItem $item
     * @return \ArrayType\ArrayOfDriverSocialProfileItem
     */
    public function addToDriverSocialProfileItem(\StructType\DriverSocialProfileItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DriverSocialProfileItem) {
            throw new \InvalidArgumentException(sprintf('The DriverSocialProfileItem property can only contain items of type \StructType\DriverSocialProfileItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DriverSocialProfileItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DriverSocialProfileItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DriverSocialProfileItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DriverSocialProfileItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DriverSocialProfileItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DriverSocialProfileItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DriverSocialProfileItem
     */
    public function getAttributeName()
    {
        return 'DriverSocialProfileItem';
    }
}
