<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDocumentsResult_V5 ArrayType
 * @subpackage Arrays
 */
class ArrayOfDocumentsResult_V5 extends AbstractStructArrayBase
{
    /**
     * The DocumentsResult_V5
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DocumentsResult_V5[]
     */
    public $DocumentsResult_V5;
    /**
     * Constructor method for ArrayOfDocumentsResult_V5
     * @uses ArrayOfDocumentsResult_V5::setDocumentsResult_V5()
     * @param \StructType\DocumentsResult_V5[] $documentsResult_V5
     */
    public function __construct(array $documentsResult_V5 = array())
    {
        $this
            ->setDocumentsResult_V5($documentsResult_V5);
    }
    /**
     * Get DocumentsResult_V5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DocumentsResult_V5[]|null
     */
    public function getDocumentsResult_V5()
    {
        return isset($this->DocumentsResult_V5) ? $this->DocumentsResult_V5 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDocumentsResult_V5 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentsResult_V5 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentsResult_V5ForArrayConstraintsFromSetDocumentsResult_V5(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDocumentsResult_V5DocumentsResult_V5Item) {
            // validation for constraint: itemType
            if (!$arrayOfDocumentsResult_V5DocumentsResult_V5Item instanceof \StructType\DocumentsResult_V5) {
                $invalidValues[] = is_object($arrayOfDocumentsResult_V5DocumentsResult_V5Item) ? get_class($arrayOfDocumentsResult_V5DocumentsResult_V5Item) : sprintf('%s(%s)', gettype($arrayOfDocumentsResult_V5DocumentsResult_V5Item), var_export($arrayOfDocumentsResult_V5DocumentsResult_V5Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocumentsResult_V5 property can only contain items of type \StructType\DocumentsResult_V5, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocumentsResult_V5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentsResult_V5[] $documentsResult_V5
     * @return \ArrayType\ArrayOfDocumentsResult_V5
     */
    public function setDocumentsResult_V5(array $documentsResult_V5 = array())
    {
        // validation for constraint: array
        if ('' !== ($documentsResult_V5ArrayErrorMessage = self::validateDocumentsResult_V5ForArrayConstraintsFromSetDocumentsResult_V5($documentsResult_V5))) {
            throw new \InvalidArgumentException($documentsResult_V5ArrayErrorMessage, __LINE__);
        }
        if (is_null($documentsResult_V5) || (is_array($documentsResult_V5) && empty($documentsResult_V5))) {
            unset($this->DocumentsResult_V5);
        } else {
            $this->DocumentsResult_V5 = $documentsResult_V5;
        }
        return $this;
    }
    /**
     * Add item to DocumentsResult_V5 value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentsResult_V5 $item
     * @return \ArrayType\ArrayOfDocumentsResult_V5
     */
    public function addToDocumentsResult_V5(\StructType\DocumentsResult_V5 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DocumentsResult_V5) {
            throw new \InvalidArgumentException(sprintf('The DocumentsResult_V5 property can only contain items of type \StructType\DocumentsResult_V5, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DocumentsResult_V5[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DocumentsResult_V5|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DocumentsResult_V5|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DocumentsResult_V5|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DocumentsResult_V5|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DocumentsResult_V5|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DocumentsResult_V5
     */
    public function getAttributeName()
    {
        return 'DocumentsResult_V5';
    }
}
