<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDocument_V3 ArrayType
 * @subpackage Arrays
 */
class ArrayOfDocument_V3 extends AbstractStructArrayBase
{
    /**
     * The Document_V3
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Document_V3[]
     */
    public $Document_V3;
    /**
     * Constructor method for ArrayOfDocument_V3
     * @uses ArrayOfDocument_V3::setDocument_V3()
     * @param \StructType\Document_V3[] $document_V3
     */
    public function __construct(array $document_V3 = array())
    {
        $this
            ->setDocument_V3($document_V3);
    }
    /**
     * Get Document_V3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Document_V3[]|null
     */
    public function getDocument_V3()
    {
        return isset($this->Document_V3) ? $this->Document_V3 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDocument_V3 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocument_V3 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocument_V3ForArrayConstraintsFromSetDocument_V3(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDocument_V3Document_V3Item) {
            // validation for constraint: itemType
            if (!$arrayOfDocument_V3Document_V3Item instanceof \StructType\Document_V3) {
                $invalidValues[] = is_object($arrayOfDocument_V3Document_V3Item) ? get_class($arrayOfDocument_V3Document_V3Item) : sprintf('%s(%s)', gettype($arrayOfDocument_V3Document_V3Item), var_export($arrayOfDocument_V3Document_V3Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Document_V3 property can only contain items of type \StructType\Document_V3, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Document_V3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Document_V3[] $document_V3
     * @return \ArrayType\ArrayOfDocument_V3
     */
    public function setDocument_V3(array $document_V3 = array())
    {
        // validation for constraint: array
        if ('' !== ($document_V3ArrayErrorMessage = self::validateDocument_V3ForArrayConstraintsFromSetDocument_V3($document_V3))) {
            throw new \InvalidArgumentException($document_V3ArrayErrorMessage, __LINE__);
        }
        if (is_null($document_V3) || (is_array($document_V3) && empty($document_V3))) {
            unset($this->Document_V3);
        } else {
            $this->Document_V3 = $document_V3;
        }
        return $this;
    }
    /**
     * Add item to Document_V3 value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_V3 $item
     * @return \ArrayType\ArrayOfDocument_V3
     */
    public function addToDocument_V3(\StructType\Document_V3 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document_V3) {
            throw new \InvalidArgumentException(sprintf('The Document_V3 property can only contain items of type \StructType\Document_V3, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Document_V3[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Document_V3|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Document_V3|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Document_V3|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Document_V3|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Document_V3|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Document_V3
     */
    public function getAttributeName()
    {
        return 'Document_V3';
    }
}
