<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDocumentResult_V3 ArrayType
 * @subpackage Arrays
 */
class ArrayOfDocumentResult_V3 extends AbstractStructArrayBase
{
    /**
     * The DocumentResult_V3
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DocumentResult_V3[]
     */
    public $DocumentResult_V3;
    /**
     * Constructor method for ArrayOfDocumentResult_V3
     * @uses ArrayOfDocumentResult_V3::setDocumentResult_V3()
     * @param \StructType\DocumentResult_V3[] $documentResult_V3
     */
    public function __construct(array $documentResult_V3 = array())
    {
        $this
            ->setDocumentResult_V3($documentResult_V3);
    }
    /**
     * Get DocumentResult_V3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DocumentResult_V3[]|null
     */
    public function getDocumentResult_V3()
    {
        return isset($this->DocumentResult_V3) ? $this->DocumentResult_V3 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDocumentResult_V3 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentResult_V3 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentResult_V3ForArrayConstraintsFromSetDocumentResult_V3(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDocumentResult_V3DocumentResult_V3Item) {
            // validation for constraint: itemType
            if (!$arrayOfDocumentResult_V3DocumentResult_V3Item instanceof \StructType\DocumentResult_V3) {
                $invalidValues[] = is_object($arrayOfDocumentResult_V3DocumentResult_V3Item) ? get_class($arrayOfDocumentResult_V3DocumentResult_V3Item) : sprintf('%s(%s)', gettype($arrayOfDocumentResult_V3DocumentResult_V3Item), var_export($arrayOfDocumentResult_V3DocumentResult_V3Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocumentResult_V3 property can only contain items of type \StructType\DocumentResult_V3, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocumentResult_V3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentResult_V3[] $documentResult_V3
     * @return \ArrayType\ArrayOfDocumentResult_V3
     */
    public function setDocumentResult_V3(array $documentResult_V3 = array())
    {
        // validation for constraint: array
        if ('' !== ($documentResult_V3ArrayErrorMessage = self::validateDocumentResult_V3ForArrayConstraintsFromSetDocumentResult_V3($documentResult_V3))) {
            throw new \InvalidArgumentException($documentResult_V3ArrayErrorMessage, __LINE__);
        }
        if (is_null($documentResult_V3) || (is_array($documentResult_V3) && empty($documentResult_V3))) {
            unset($this->DocumentResult_V3);
        } else {
            $this->DocumentResult_V3 = $documentResult_V3;
        }
        return $this;
    }
    /**
     * Add item to DocumentResult_V3 value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentResult_V3 $item
     * @return \ArrayType\ArrayOfDocumentResult_V3
     */
    public function addToDocumentResult_V3(\StructType\DocumentResult_V3 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DocumentResult_V3) {
            throw new \InvalidArgumentException(sprintf('The DocumentResult_V3 property can only contain items of type \StructType\DocumentResult_V3, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DocumentResult_V3[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DocumentResult_V3|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DocumentResult_V3|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DocumentResult_V3|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DocumentResult_V3|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DocumentResult_V3|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DocumentResult_V3
     */
    public function getAttributeName()
    {
        return 'DocumentResult_V3';
    }
}
