<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDiagnosticSearchItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfDiagnosticSearchItem extends AbstractStructArrayBase
{
    /**
     * The DiagnosticSearchItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DiagnosticSearchItem[]
     */
    public $DiagnosticSearchItem;
    /**
     * Constructor method for ArrayOfDiagnosticSearchItem
     * @uses ArrayOfDiagnosticSearchItem::setDiagnosticSearchItem()
     * @param \StructType\DiagnosticSearchItem[] $diagnosticSearchItem
     */
    public function __construct(array $diagnosticSearchItem = array())
    {
        $this
            ->setDiagnosticSearchItem($diagnosticSearchItem);
    }
    /**
     * Get DiagnosticSearchItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DiagnosticSearchItem[]|null
     */
    public function getDiagnosticSearchItem()
    {
        return isset($this->DiagnosticSearchItem) ? $this->DiagnosticSearchItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDiagnosticSearchItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDiagnosticSearchItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDiagnosticSearchItemForArrayConstraintsFromSetDiagnosticSearchItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDiagnosticSearchItemDiagnosticSearchItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfDiagnosticSearchItemDiagnosticSearchItemItem instanceof \StructType\DiagnosticSearchItem) {
                $invalidValues[] = is_object($arrayOfDiagnosticSearchItemDiagnosticSearchItemItem) ? get_class($arrayOfDiagnosticSearchItemDiagnosticSearchItemItem) : sprintf('%s(%s)', gettype($arrayOfDiagnosticSearchItemDiagnosticSearchItemItem), var_export($arrayOfDiagnosticSearchItemDiagnosticSearchItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DiagnosticSearchItem property can only contain items of type \StructType\DiagnosticSearchItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DiagnosticSearchItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DiagnosticSearchItem[] $diagnosticSearchItem
     * @return \ArrayType\ArrayOfDiagnosticSearchItem
     */
    public function setDiagnosticSearchItem(array $diagnosticSearchItem = array())
    {
        // validation for constraint: array
        if ('' !== ($diagnosticSearchItemArrayErrorMessage = self::validateDiagnosticSearchItemForArrayConstraintsFromSetDiagnosticSearchItem($diagnosticSearchItem))) {
            throw new \InvalidArgumentException($diagnosticSearchItemArrayErrorMessage, __LINE__);
        }
        if (is_null($diagnosticSearchItem) || (is_array($diagnosticSearchItem) && empty($diagnosticSearchItem))) {
            unset($this->DiagnosticSearchItem);
        } else {
            $this->DiagnosticSearchItem = $diagnosticSearchItem;
        }
        return $this;
    }
    /**
     * Add item to DiagnosticSearchItem value
     * @throws \InvalidArgumentException
     * @param \StructType\DiagnosticSearchItem $item
     * @return \ArrayType\ArrayOfDiagnosticSearchItem
     */
    public function addToDiagnosticSearchItem(\StructType\DiagnosticSearchItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DiagnosticSearchItem) {
            throw new \InvalidArgumentException(sprintf('The DiagnosticSearchItem property can only contain items of type \StructType\DiagnosticSearchItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DiagnosticSearchItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DiagnosticSearchItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DiagnosticSearchItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DiagnosticSearchItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DiagnosticSearchItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DiagnosticSearchItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DiagnosticSearchItem
     */
    public function getAttributeName()
    {
        return 'DiagnosticSearchItem';
    }
}
