<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDiagnosticItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfDiagnosticItem extends AbstractStructArrayBase
{
    /**
     * The DiagnosticItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DiagnosticItem[]
     */
    public $DiagnosticItem;
    /**
     * Constructor method for ArrayOfDiagnosticItem
     * @uses ArrayOfDiagnosticItem::setDiagnosticItem()
     * @param \StructType\DiagnosticItem[] $diagnosticItem
     */
    public function __construct(array $diagnosticItem = array())
    {
        $this
            ->setDiagnosticItem($diagnosticItem);
    }
    /**
     * Get DiagnosticItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DiagnosticItem[]|null
     */
    public function getDiagnosticItem()
    {
        return isset($this->DiagnosticItem) ? $this->DiagnosticItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDiagnosticItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDiagnosticItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDiagnosticItemForArrayConstraintsFromSetDiagnosticItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDiagnosticItemDiagnosticItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfDiagnosticItemDiagnosticItemItem instanceof \StructType\DiagnosticItem) {
                $invalidValues[] = is_object($arrayOfDiagnosticItemDiagnosticItemItem) ? get_class($arrayOfDiagnosticItemDiagnosticItemItem) : sprintf('%s(%s)', gettype($arrayOfDiagnosticItemDiagnosticItemItem), var_export($arrayOfDiagnosticItemDiagnosticItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DiagnosticItem property can only contain items of type \StructType\DiagnosticItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DiagnosticItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DiagnosticItem[] $diagnosticItem
     * @return \ArrayType\ArrayOfDiagnosticItem
     */
    public function setDiagnosticItem(array $diagnosticItem = array())
    {
        // validation for constraint: array
        if ('' !== ($diagnosticItemArrayErrorMessage = self::validateDiagnosticItemForArrayConstraintsFromSetDiagnosticItem($diagnosticItem))) {
            throw new \InvalidArgumentException($diagnosticItemArrayErrorMessage, __LINE__);
        }
        if (is_null($diagnosticItem) || (is_array($diagnosticItem) && empty($diagnosticItem))) {
            unset($this->DiagnosticItem);
        } else {
            $this->DiagnosticItem = $diagnosticItem;
        }
        return $this;
    }
    /**
     * Add item to DiagnosticItem value
     * @throws \InvalidArgumentException
     * @param \StructType\DiagnosticItem $item
     * @return \ArrayType\ArrayOfDiagnosticItem
     */
    public function addToDiagnosticItem(\StructType\DiagnosticItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DiagnosticItem) {
            throw new \InvalidArgumentException(sprintf('The DiagnosticItem property can only contain items of type \StructType\DiagnosticItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DiagnosticItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DiagnosticItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DiagnosticItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DiagnosticItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DiagnosticItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DiagnosticItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DiagnosticItem
     */
    public function getAttributeName()
    {
        return 'DiagnosticItem';
    }
}
