<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfConsultation_V5 ArrayType
 * @subpackage Arrays
 */
class ArrayOfConsultation_V5 extends AbstractStructArrayBase
{
    /**
     * The Consultation_V5
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Consultation_V5[]
     */
    public $Consultation_V5;
    /**
     * Constructor method for ArrayOfConsultation_V5
     * @uses ArrayOfConsultation_V5::setConsultation_V5()
     * @param \StructType\Consultation_V5[] $consultation_V5
     */
    public function __construct(array $consultation_V5 = array())
    {
        $this
            ->setConsultation_V5($consultation_V5);
    }
    /**
     * Get Consultation_V5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Consultation_V5[]|null
     */
    public function getConsultation_V5()
    {
        return isset($this->Consultation_V5) ? $this->Consultation_V5 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setConsultation_V5 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConsultation_V5 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConsultation_V5ForArrayConstraintsFromSetConsultation_V5(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfConsultation_V5Consultation_V5Item) {
            // validation for constraint: itemType
            if (!$arrayOfConsultation_V5Consultation_V5Item instanceof \StructType\Consultation_V5) {
                $invalidValues[] = is_object($arrayOfConsultation_V5Consultation_V5Item) ? get_class($arrayOfConsultation_V5Consultation_V5Item) : sprintf('%s(%s)', gettype($arrayOfConsultation_V5Consultation_V5Item), var_export($arrayOfConsultation_V5Consultation_V5Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Consultation_V5 property can only contain items of type \StructType\Consultation_V5, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Consultation_V5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Consultation_V5[] $consultation_V5
     * @return \ArrayType\ArrayOfConsultation_V5
     */
    public function setConsultation_V5(array $consultation_V5 = array())
    {
        // validation for constraint: array
        if ('' !== ($consultation_V5ArrayErrorMessage = self::validateConsultation_V5ForArrayConstraintsFromSetConsultation_V5($consultation_V5))) {
            throw new \InvalidArgumentException($consultation_V5ArrayErrorMessage, __LINE__);
        }
        if (is_null($consultation_V5) || (is_array($consultation_V5) && empty($consultation_V5))) {
            unset($this->Consultation_V5);
        } else {
            $this->Consultation_V5 = $consultation_V5;
        }
        return $this;
    }
    /**
     * Add item to Consultation_V5 value
     * @throws \InvalidArgumentException
     * @param \StructType\Consultation_V5 $item
     * @return \ArrayType\ArrayOfConsultation_V5
     */
    public function addToConsultation_V5(\StructType\Consultation_V5 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Consultation_V5) {
            throw new \InvalidArgumentException(sprintf('The Consultation_V5 property can only contain items of type \StructType\Consultation_V5, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Consultation_V5[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Consultation_V5|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Consultation_V5|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Consultation_V5|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Consultation_V5|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Consultation_V5|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Consultation_V5
     */
    public function getAttributeName()
    {
        return 'Consultation_V5';
    }
}
