<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfConsultation ArrayType
 * @subpackage Arrays
 */
class ArrayOfConsultation extends AbstractStructArrayBase
{
    /**
     * The Consultation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Consultation[]
     */
    public $Consultation;
    /**
     * Constructor method for ArrayOfConsultation
     * @uses ArrayOfConsultation::setConsultation()
     * @param \StructType\Consultation[] $consultation
     */
    public function __construct(array $consultation = array())
    {
        $this
            ->setConsultation($consultation);
    }
    /**
     * Get Consultation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Consultation[]|null
     */
    public function getConsultation()
    {
        return isset($this->Consultation) ? $this->Consultation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setConsultation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConsultation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConsultationForArrayConstraintsFromSetConsultation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfConsultationConsultationItem) {
            // validation for constraint: itemType
            if (!$arrayOfConsultationConsultationItem instanceof \StructType\Consultation) {
                $invalidValues[] = is_object($arrayOfConsultationConsultationItem) ? get_class($arrayOfConsultationConsultationItem) : sprintf('%s(%s)', gettype($arrayOfConsultationConsultationItem), var_export($arrayOfConsultationConsultationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Consultation property can only contain items of type \StructType\Consultation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Consultation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Consultation[] $consultation
     * @return \ArrayType\ArrayOfConsultation
     */
    public function setConsultation(array $consultation = array())
    {
        // validation for constraint: array
        if ('' !== ($consultationArrayErrorMessage = self::validateConsultationForArrayConstraintsFromSetConsultation($consultation))) {
            throw new \InvalidArgumentException($consultationArrayErrorMessage, __LINE__);
        }
        if (is_null($consultation) || (is_array($consultation) && empty($consultation))) {
            unset($this->Consultation);
        } else {
            $this->Consultation = $consultation;
        }
        return $this;
    }
    /**
     * Add item to Consultation value
     * @throws \InvalidArgumentException
     * @param \StructType\Consultation $item
     * @return \ArrayType\ArrayOfConsultation
     */
    public function addToConsultation(\StructType\Consultation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Consultation) {
            throw new \InvalidArgumentException(sprintf('The Consultation property can only contain items of type \StructType\Consultation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Consultation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Consultation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Consultation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Consultation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Consultation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Consultation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Consultation
     */
    public function getAttributeName()
    {
        return 'Consultation';
    }
}
