<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfConnectGroup ArrayType
 * @subpackage Arrays
 */
class ArrayOfConnectGroup extends AbstractStructArrayBase
{
    /**
     * The ConnectGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ConnectGroup[]
     */
    public $ConnectGroup;
    /**
     * Constructor method for ArrayOfConnectGroup
     * @uses ArrayOfConnectGroup::setConnectGroup()
     * @param \StructType\ConnectGroup[] $connectGroup
     */
    public function __construct(array $connectGroup = array())
    {
        $this
            ->setConnectGroup($connectGroup);
    }
    /**
     * Get ConnectGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ConnectGroup[]|null
     */
    public function getConnectGroup()
    {
        return isset($this->ConnectGroup) ? $this->ConnectGroup : null;
    }
    /**
     * This method is responsible for validating the values passed to the setConnectGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConnectGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConnectGroupForArrayConstraintsFromSetConnectGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfConnectGroupConnectGroupItem) {
            // validation for constraint: itemType
            if (!$arrayOfConnectGroupConnectGroupItem instanceof \StructType\ConnectGroup) {
                $invalidValues[] = is_object($arrayOfConnectGroupConnectGroupItem) ? get_class($arrayOfConnectGroupConnectGroupItem) : sprintf('%s(%s)', gettype($arrayOfConnectGroupConnectGroupItem), var_export($arrayOfConnectGroupConnectGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ConnectGroup property can only contain items of type \StructType\ConnectGroup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ConnectGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ConnectGroup[] $connectGroup
     * @return \ArrayType\ArrayOfConnectGroup
     */
    public function setConnectGroup(array $connectGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($connectGroupArrayErrorMessage = self::validateConnectGroupForArrayConstraintsFromSetConnectGroup($connectGroup))) {
            throw new \InvalidArgumentException($connectGroupArrayErrorMessage, __LINE__);
        }
        if (is_null($connectGroup) || (is_array($connectGroup) && empty($connectGroup))) {
            unset($this->ConnectGroup);
        } else {
            $this->ConnectGroup = $connectGroup;
        }
        return $this;
    }
    /**
     * Add item to ConnectGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\ConnectGroup $item
     * @return \ArrayType\ArrayOfConnectGroup
     */
    public function addToConnectGroup(\StructType\ConnectGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConnectGroup) {
            throw new \InvalidArgumentException(sprintf('The ConnectGroup property can only contain items of type \StructType\ConnectGroup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ConnectGroup[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ConnectGroup|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ConnectGroup|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ConnectGroup|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ConnectGroup|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ConnectGroup|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ConnectGroup
     */
    public function getAttributeName()
    {
        return 'ConnectGroup';
    }
}
