<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCompanyCardResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfCompanyCardResult extends AbstractStructArrayBase
{
    /**
     * The CompanyCardResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CompanyCardResult[]
     */
    public $CompanyCardResult;
    /**
     * Constructor method for ArrayOfCompanyCardResult
     * @uses ArrayOfCompanyCardResult::setCompanyCardResult()
     * @param \StructType\CompanyCardResult[] $companyCardResult
     */
    public function __construct(array $companyCardResult = array())
    {
        $this
            ->setCompanyCardResult($companyCardResult);
    }
    /**
     * Get CompanyCardResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CompanyCardResult[]|null
     */
    public function getCompanyCardResult()
    {
        return isset($this->CompanyCardResult) ? $this->CompanyCardResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCompanyCardResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompanyCardResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompanyCardResultForArrayConstraintsFromSetCompanyCardResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCompanyCardResultCompanyCardResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfCompanyCardResultCompanyCardResultItem instanceof \StructType\CompanyCardResult) {
                $invalidValues[] = is_object($arrayOfCompanyCardResultCompanyCardResultItem) ? get_class($arrayOfCompanyCardResultCompanyCardResultItem) : sprintf('%s(%s)', gettype($arrayOfCompanyCardResultCompanyCardResultItem), var_export($arrayOfCompanyCardResultCompanyCardResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CompanyCardResult property can only contain items of type \StructType\CompanyCardResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CompanyCardResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyCardResult[] $companyCardResult
     * @return \ArrayType\ArrayOfCompanyCardResult
     */
    public function setCompanyCardResult(array $companyCardResult = array())
    {
        // validation for constraint: array
        if ('' !== ($companyCardResultArrayErrorMessage = self::validateCompanyCardResultForArrayConstraintsFromSetCompanyCardResult($companyCardResult))) {
            throw new \InvalidArgumentException($companyCardResultArrayErrorMessage, __LINE__);
        }
        if (is_null($companyCardResult) || (is_array($companyCardResult) && empty($companyCardResult))) {
            unset($this->CompanyCardResult);
        } else {
            $this->CompanyCardResult = $companyCardResult;
        }
        return $this;
    }
    /**
     * Add item to CompanyCardResult value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyCardResult $item
     * @return \ArrayType\ArrayOfCompanyCardResult
     */
    public function addToCompanyCardResult(\StructType\CompanyCardResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanyCardResult) {
            throw new \InvalidArgumentException(sprintf('The CompanyCardResult property can only contain items of type \StructType\CompanyCardResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CompanyCardResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CompanyCardResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CompanyCardResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CompanyCardResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CompanyCardResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CompanyCardResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CompanyCardResult
     */
    public function getAttributeName()
    {
        return 'CompanyCardResult';
    }
}
